/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.docx4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.docx4j.Docx4J;
import org.docx4j.model.fields.FieldUpdater;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.springframework.content.commons.io.CloseableObserver;
import org.springframework.content.commons.io.FileRemover;
import org.springframework.content.commons.io.ObservableInputStream;
import org.springframework.content.commons.renditions.RenditionProvider;
import org.springframework.stereotype.Service;

@Service
public class WordToPdfRenditionProvider
implements RenditionProvider {
    private static final Log logger = LogFactory.getLog(WordToPdfRenditionProvider.class);

    public String consumes() {
        return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    }

    public String[] produces() {
        return new String[]{"application/pdf"};
    }

    public InputStream convert(InputStream fromInputSource, String toMimeType) {
        try {
            WordprocessingMLPackage pkg = WordprocessingMLPackage.load((InputStream)fromInputSource);
            FieldUpdater updater = new FieldUpdater(pkg);
            updater.update(true);
            File tmpFile = Files.createTempFile(null, null, new FileAttribute[0]).toFile();
            FileOutputStream os = new FileOutputStream(tmpFile);
            Docx4J.toPDF((WordprocessingMLPackage)pkg, (OutputStream)os);
            return new ObservableInputStream((InputStream)new FileInputStream(tmpFile), (CloseableObserver)new FileRemover(tmpFile));
        }
        catch (Exception e) {
            logger.warn((Object)String.format("%s rendition failed", toMimeType), (Throwable)e);
            return null;
        }
    }
}

