/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.elasticsearch;

import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.indices.CreateIndex;
import java.io.IOException;
import org.springframework.content.commons.repository.StoreAccessException;

public class ElasticsearchIndexFactory {
    private final JestClient client;

    public ElasticsearchIndexFactory(JestClient client) {
        this.client = client;
    }

    public void createIndexes(String[] stores) {
        for (String store : stores) {
            CreateIndex index = new CreateIndex.Builder(store).build();
            try {
                JestResult result = this.client.execute((Action)index);
                if (result.isSucceeded()) continue;
                throw new StoreAccessException(String.format("Unexpected error creating elasticsearch index for store %s", store, result.getErrorMessage()));
            }
            catch (IOException e) {
                throw new StoreAccessException(String.format("Unexpected error creating elasticsearch index for store %s", store), (Throwable)e);
            }
        }
    }
}

