/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.elasticsearch;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.content.commons.repository.StoreAccessException;
import org.springframework.content.commons.search.Searchable;
import org.springframework.content.elasticsearch.Content;

public class ElasticsearchSearcher
implements Searchable<Serializable> {
    private JestClient client;

    public ElasticsearchSearcher(JestClient client) {
        this.client = client;
    }

    public Iterable<Serializable> findKeyword(String query) {
        SearchResult result;
        Search search = this.getSearch(query);
        try {
            result = (SearchResult)this.client.execute((Action)search);
        }
        catch (IOException e) {
            throw new StoreAccessException(String.format("Exception while searching for %s", query), (Throwable)e);
        }
        return this.getIDs(result);
    }

    public Iterable<Serializable> findAllKeywords(String ... terms) {
        SearchResult result;
        StringBuilder qb = this.join("AND", terms);
        Search search = this.getSearch(qb.toString());
        try {
            result = (SearchResult)this.client.execute((Action)search);
        }
        catch (IOException e) {
            throw new StoreAccessException(String.format("Exception while searching for %s", qb), (Throwable)e);
        }
        return this.getIDs(result);
    }

    public Iterable<Serializable> findAnyKeywords(String ... terms) {
        SearchResult result;
        StringBuilder qb = this.join("OR", terms);
        Search search = this.getSearch(qb.toString());
        try {
            result = (SearchResult)this.client.execute((Action)search);
        }
        catch (IOException e) {
            throw new StoreAccessException(String.format("Exception while searching for %s", qb), (Throwable)e);
        }
        return this.getIDs(result);
    }

    public Iterable<Serializable> findKeywordsNear(int proximity, String ... terms) {
        SearchResult result;
        StringBuilder sb = this.join("", terms);
        String finalString = String.format("\\\"%s\\\"~%s", sb.toString(), proximity);
        Search search = this.getSearch(finalString);
        try {
            result = (SearchResult)this.client.execute((Action)search);
        }
        catch (IOException e) {
            throw new StoreAccessException(String.format("Exception while searching for keywords %s near %s", sb.toString(), proximity), (Throwable)e);
        }
        return this.getIDs(result);
    }

    public Iterable<Serializable> findKeywordStartsWith(String term) {
        SearchResult result;
        String finalString = String.format("%s*", term);
        Search search = this.getSearch(finalString);
        try {
            result = (SearchResult)this.client.execute((Action)search);
        }
        catch (IOException e) {
            throw new StoreAccessException(String.format("Exception while searching for keyword %s that start with %s", finalString, term), (Throwable)e);
        }
        return this.getIDs(result);
    }

    public Iterable<Serializable> findKeywordStartsWithAndEndsWith(String a, String b) {
        SearchResult result;
        String finalString = String.format("%s*%s", a, b);
        Search search = this.getSearch(finalString);
        try {
            result = (SearchResult)this.client.execute((Action)search);
        }
        catch (IOException e) {
            throw new StoreAccessException(String.format("Exception while searching for keyword %s that start with %s and ends with %s", finalString, a, b), (Throwable)e);
        }
        return this.getIDs(result);
    }

    public Iterable<Serializable> findAllKeywordsWithWeights(String[] terms, double[] weights) {
        SearchResult result;
        String finalString = "";
        for (int i = 0; i < weights.length; ++i) {
            finalString = String.format("%s%s^%s ", finalString, terms[i], weights[i]);
        }
        finalString = finalString.substring(0, finalString.length() - 1);
        Search search = this.getSearch(finalString);
        try {
            result = (SearchResult)this.client.execute((Action)search);
        }
        catch (IOException e) {
            throw new StoreAccessException(String.format("Exception while searching for %s.", finalString), (Throwable)e);
        }
        return this.getIDs(result);
    }

    private Search getSearch(String query) {
        JsonParser parser = new JsonParser();
        JsonObject payload = parser.parse(String.format("{\"query\":{\"query_string\":{\"query\":\"%s\"}}}", query)).getAsJsonObject();
        return ((Search.Builder)((Search.Builder)new Search.Builder(payload.toString()).addIndex("docs")).addType("doc")).build();
    }

    private List<Serializable> getIDs(SearchResult result) {
        List<Serializable> contents = new ArrayList<Serializable>();
        if (result != null) {
            List hits = result.getHits(Content.class);
            contents = hits.stream().map(hit -> ((Content)hit.source).getId()).collect(Collectors.toList());
        }
        return contents;
    }

    private StringBuilder join(String delimiter, String ... terms) {
        StringBuilder qb = new StringBuilder();
        for (int i = 0; i < terms.length; ++i) {
            if (i > 0) {
                if (delimiter.isEmpty()) {
                    qb.append(" ");
                } else {
                    qb.append(String.format(" %s ", delimiter));
                }
            }
            qb.append(terms[i]);
        }
        return qb;
    }
}

