/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.elasticsearch;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.ingest.GetPipelineRequest;
import org.elasticsearch.action.ingest.GetPipelineResponse;
import org.elasticsearch.action.ingest.PutPipelineRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentType;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.annotations.StoreEventHandler;
import org.springframework.content.commons.repository.StoreAccessException;
import org.springframework.content.commons.repository.events.AbstractStoreEventListener;
import org.springframework.content.commons.repository.events.AfterSetContentEvent;
import org.springframework.content.commons.repository.events.BeforeUnsetContentEvent;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.util.Assert;

@StoreEventHandler
public class ElasticsearchIndexer
extends AbstractStoreEventListener<Object> {
    public static final String INDEX_NAME = "spring-content-fulltext-index";
    private static final Log LOGGER = LogFactory.getLog(ElasticsearchIndexer.class);
    private static final String SPRING_CONTENT_ATTACHMENT = "spring-content-attachment-pipeline";
    private static final int BUFFER_SIZE = 3072;
    private RestHighLevelClient client;

    public ElasticsearchIndexer(RestHighLevelClient client) throws IOException {
        this.client = client;
        this.ensureAttachmentPipeline();
    }

    protected void onAfterSetContent(AfterSetContentEvent event) {
        String id = BeanUtils.getFieldWithAnnotation((Object)event.getSource(), ContentId.class).toString();
        InputStream stream = event.getStore().getContent(event.getSource());
        StringBuilder result = new StringBuilder();
        try (BufferedInputStream in = new BufferedInputStream(stream, 3072);){
            Base64.Encoder encoder = Base64.getEncoder();
            byte[] chunk = new byte[3072];
            int len = 0;
            while ((len = in.read(chunk)) == 3072) {
                result.append(encoder.encodeToString(chunk));
            }
            if (len > 0) {
                chunk = Arrays.copyOf(chunk, len);
                result.append(encoder.encodeToString(chunk));
            }
        }
        catch (IOException e) {
            throw new StoreAccessException(String.format("Error base64 encoding stream for content %s", id), (Throwable)e);
        }
        IndexRequest req = new IndexRequest(INDEX_NAME, event.getSource().getClass().getName(), id);
        req.setPipeline(SPRING_CONTENT_ATTACHMENT);
        String source = "{\"data\": \"" + result.toString() + "\"}";
        req.source(source, XContentType.JSON);
        try {
            IndexResponse res = this.client.index(req, RequestOptions.DEFAULT);
            LOGGER.info((Object)String.format("Content '%s' indexed with result %s", id, res.getResult()));
        }
        catch (IOException e) {
            throw new StoreAccessException(String.format("Error indexing content %s", id), (Throwable)e);
        }
    }

    protected void onBeforeUnsetContent(BeforeUnsetContentEvent event) {
        Object id = BeanUtils.getFieldWithAnnotation((Object)event.getSource(), ContentId.class);
        if (id == null) {
            return;
        }
        DeleteRequest req = new DeleteRequest(INDEX_NAME, event.getSource().getClass().getName(), id.toString());
        try {
            DeleteResponse res = this.client.delete(req, RequestOptions.DEFAULT);
            LOGGER.info((Object)String.format("Indexed content '%s' deleted with result %s", id, res.getResult()));
        }
        catch (IOException e) {
            throw new StoreAccessException(String.format("Error deleting indexed content %s", id), (Throwable)e);
        }
    }

    void ensureAttachmentPipeline() throws IOException {
        GetPipelineRequest getRequest = new GetPipelineRequest(new String[]{SPRING_CONTENT_ATTACHMENT});
        GetPipelineResponse res = this.client.ingest().getPipeline(getRequest, RequestOptions.DEFAULT);
        if (!res.isFound()) {
            String source = "{\"description\":\"Extract attachment information encoded in Base64 with UTF-8 charset\",\"processors\":[{\"attachment\":{\"field\":\"data\"}}]}";
            PutPipelineRequest put = new PutPipelineRequest(SPRING_CONTENT_ATTACHMENT, (BytesReference)new BytesArray(source.getBytes(StandardCharsets.UTF_8)), XContentType.JSON);
            AcknowledgedResponse wpr = this.client.ingest().putPipeline(put, RequestOptions.DEFAULT);
            Assert.isTrue((boolean)wpr.isAcknowledged(), (String)"Attachment pipeline not acknowledged by server");
        }
    }
}

