/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.fragments;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.repository.StoreAccessException;
import org.springframework.content.commons.search.Searchable;

public class SearchableImpl
implements Searchable<Serializable> {
    private final RestHighLevelClient client;
    private Class<?> domainClass;

    public SearchableImpl() {
        this.client = null;
        this.domainClass = null;
    }

    @Autowired
    public SearchableImpl(RestHighLevelClient client) {
        this.client = client;
    }

    public void setDomainClass(Class<?> domainClass) {
        this.domainClass = domainClass;
    }

    public Iterable<Serializable> search(String queryStr) {
        SearchRequest searchRequest = new SearchRequest(new String[]{"spring-content-fulltext-index"});
        searchRequest.types(new String[]{this.domainClass.getName()});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)QueryBuilders.simpleQueryStringQuery((String)queryStr));
        searchRequest.source(sourceBuilder);
        SearchResponse res = null;
        try {
            res = this.client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioe) {
            throw new StoreAccessException(String.format("Error searching indexed content for '%s'", queryStr), (Throwable)ioe);
        }
        return this.getIDs(res.getHits());
    }

    public Iterable<Serializable> findKeyword(String query) {
        SearchRequest searchRequest = new SearchRequest(new String[]{"spring-content-fulltext-index"});
        searchRequest.types(new String[]{this.domainClass.getName()});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)QueryBuilders.queryStringQuery((String)query));
        searchRequest.source(sourceBuilder);
        SearchResponse res = null;
        try {
            res = this.client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioe) {
            throw new StoreAccessException(String.format("Error searching indexed content for '%s'", query), (Throwable)ioe);
        }
        return this.getIDs(res.getHits());
    }

    public Iterable<Serializable> findAllKeywords(String ... terms) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Serializable> findAnyKeywords(String ... terms) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Serializable> findKeywordsNear(int proximity, String ... terms) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Serializable> findKeywordStartsWith(String term) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Serializable> findKeywordStartsWithAndEndsWith(String a, String b) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Serializable> findAllKeywordsWithWeights(String[] terms, double[] weights) {
        throw new UnsupportedOperationException();
    }

    private List<Serializable> getIDs(SearchHits result) {
        ArrayList<Serializable> contents = new ArrayList<Serializable>();
        if (result == null || result.getTotalHits() == 0L) {
            return contents;
        }
        for (SearchHit hit : result.getHits()) {
            contents.add((Serializable)((Object)hit.getId()));
        }
        return contents;
    }
}

