/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.elasticsearch;

import java.io.IOException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.rest.RestStatus;

public class IndexManager {
    public static final String INDEX_NAME = "spring-content-fulltext-index";
    private final RestHighLevelClient client;
    private static Boolean globalIndexing = null;

    public IndexManager(RestHighLevelClient client) {
        this.client = client;
    }

    public String indexName(Class<?> entityClass) {
        if (globalIndexing == null) {
            try {
                this.client.indices().get(new GetIndexRequest(new String[]{INDEX_NAME}), RequestOptions.DEFAULT);
                globalIndexing = true;
            }
            catch (ElasticsearchStatusException ese) {
                if (ese.status() == RestStatus.NOT_FOUND) {
                    globalIndexing = false;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (globalIndexing.booleanValue()) {
            return INDEX_NAME;
        }
        return entityClass.getName().toLowerCase();
    }

    public static void reset() {
        globalIndexing = null;
    }
}

