/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.fragments;

import internal.org.springframework.content.elasticsearch.ElasticsearchIndexer;
import internal.org.springframework.content.elasticsearch.IndexManager;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.SimpleQueryStringBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.fulltext.Attribute;
import org.springframework.content.commons.fulltext.Highlight;
import org.springframework.content.commons.repository.StoreAccessException;
import org.springframework.content.commons.search.Searchable;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.commons.utils.ContentPropertyUtils;
import org.springframework.content.elasticsearch.FilterQueryProvider;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class SearchableImpl
implements Searchable<Object> {
    private static final Log LOGGER = LogFactory.getLog(ElasticsearchIndexer.class);
    private final RestHighLevelClient client;
    private final IndexManager manager;
    private FilterQueryProvider filterProvider;
    private ConversionService conversionService;
    private Class<?> domainClass;
    private Class<?> idClass;
    private Class<?>[] genericArguments;

    public SearchableImpl() {
        this.client = null;
        this.manager = null;
        this.domainClass = null;
        this.idClass = null;
        this.filterProvider = null;
    }

    @Autowired
    public SearchableImpl(RestHighLevelClient client, IndexManager manager) {
        this.client = client;
        this.manager = manager;
        this.filterProvider = null;
        this.conversionService = new DefaultConversionService();
    }

    @Autowired(required=false)
    public void setFilterQueryProvider(FilterQueryProvider provider) {
        this.filterProvider = provider;
    }

    public void setDomainClass(Class<?> domainClass) {
        this.domainClass = domainClass;
    }

    public void setIdClass(Class<?> idClass) {
        this.idClass = idClass;
    }

    public void setGenericArguments(Class<?>[] genericArguments) {
        this.genericArguments = genericArguments;
    }

    public Iterable<Object> search(String queryStr) {
        return this.search(queryStr, null, this.genericArguments[0], ArrayList.class);
    }

    public Page<Object> search(String queryStr, Pageable pageable) {
        return this.search(queryStr, pageable, this.genericArguments[0], Page.class);
    }

    private <R> R search(String queryString, Pageable pageable, Class<? extends Object> searchType, Class<R> returnType) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.manager.indexName(this.domainClass)});
        searchRequest.types(new String[]{this.domainClass.getName()});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        ArrayList<String> attributesToFetch = new ArrayList<String>();
        if (!ContentPropertyUtils.isPrimitiveContentPropertyClass(searchType)) {
            for (Field field : BeanUtils.findFieldsWithAnnotation(searchType, Attribute.class, (BeanWrapper)new BeanWrapperImpl(searchType))) {
                Attribute fieldAnnotation = field.getAnnotation(Attribute.class);
                attributesToFetch.add(fieldAnnotation.name());
            }
        }
        if (attributesToFetch.size() > 0) {
            sourceBuilder.fetchSource(attributesToFetch.toArray(new String[0]), null);
        }
        SimpleQueryStringBuilder sqsb = QueryBuilders.simpleQueryStringQuery((String)queryString);
        sqsb.field("attachment.content");
        BoolQueryBuilder b = QueryBuilders.boolQuery();
        b.must((QueryBuilder)sqsb);
        if (this.filterProvider != null) {
            Map<String, Object> filters = this.filterProvider.filterQueries(this.domainClass);
            for (String attr : filters.keySet()) {
                b.filter((QueryBuilder)QueryBuilders.matchQuery((String)attr, (Object)filters.get(attr)));
            }
        }
        sourceBuilder.query((QueryBuilder)b);
        if (pageable != null) {
            sourceBuilder.from(pageable.getPageNumber() * pageable.getPageSize());
            sourceBuilder.size(pageable.getPageSize());
        }
        if (!ContentPropertyUtils.isPrimitiveContentPropertyClass(searchType) && BeanUtils.findFieldWithAnnotation(searchType, Highlight.class) != null) {
            HighlightBuilder hb = SearchSourceBuilder.highlight();
            hb.field("attachment.content");
            sourceBuilder.highlighter(hb);
        }
        searchRequest.source(sourceBuilder);
        SearchResponse res = null;
        try {
            res = this.client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException | ElasticsearchStatusException e) {
            LOGGER.error((Object)String.format("Error searching indexed content for '%s'", queryString), e);
            throw new StoreAccessException(String.format("Error searching indexed content for '%s'", queryString), e);
        }
        return this.getResults(res.getHits(), pageable, searchType, returnType);
    }

    public Iterable<Object> findKeyword(String query) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.manager.indexName(this.domainClass)});
        searchRequest.types(new String[]{this.domainClass.getName()});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)QueryBuilders.queryStringQuery((String)query));
        searchRequest.source(sourceBuilder);
        SearchResponse res = null;
        try {
            res = this.client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioe) {
            throw new StoreAccessException(String.format("Error searching indexed content for '%s'", query), (Throwable)ioe);
        }
        return this.getIDs(res.getHits());
    }

    public Iterable<Object> findAllKeywords(String ... terms) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Object> findAnyKeywords(String ... terms) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Object> findKeywordsNear(int proximity, String ... terms) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Object> findKeywordStartsWith(String term) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Object> findKeywordStartsWithAndEndsWith(String a, String b) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Object> findAllKeywordsWithWeights(String[] terms, double[] weights) {
        throw new UnsupportedOperationException();
    }

    private List<Object> getIDs(SearchHits result) {
        ArrayList<Object> contents = new ArrayList<Object>();
        if (result == null || result.getTotalHits().value == 0L) {
            return contents;
        }
        for (SearchHit hit : result.getHits()) {
            contents.add(hit.getId());
        }
        return contents;
    }

    private <R> R getResults(SearchHits result, Pageable pageable, Class<?> resultType, Class<R> returnType) {
        ArrayList<Object> contents = new ArrayList<Object>();
        if (result == null || result.getTotalHits().value == 0L) {
            return this.wrapResult(returnType, contents, pageable, 0L);
        }
        for (SearchHit hit : result.getHits()) {
            try {
                Field highlightField;
                if (ContentPropertyUtils.isPrimitiveContentPropertyClass(resultType)) {
                    contents.add(this.conversionService.convert((Object)hit.getId(), TypeDescriptor.valueOf(String.class), TypeDescriptor.valueOf(this.idClass)));
                    continue;
                }
                Object row = resultType.newInstance();
                BeanWrapperImpl wrapper = new BeanWrapperImpl(row);
                String id = hit.getId();
                Field contentIdField = BeanUtils.findFieldWithAnnotation(resultType, ContentId.class);
                if (contentIdField != null) {
                    wrapper.setPropertyValue(contentIdField.getName(), (Object)id);
                }
                if ((highlightField = BeanUtils.findFieldWithAnnotation(resultType, Highlight.class)) != null) {
                    wrapper.setPropertyValue(highlightField.getName(), (Object)((HighlightField)hit.getHighlightFields().get("attachment.content")).getFragments()[0].string());
                }
                for (Field field : BeanUtils.findFieldsWithAnnotation(resultType, Attribute.class, (BeanWrapper)new BeanWrapperImpl(resultType))) {
                    Attribute fieldAnnotation = field.getAnnotation(Attribute.class);
                    wrapper.setPropertyValue(field.getName(), hit.getSourceAsMap().get(fieldAnnotation.name()));
                }
                contents.add(row);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return this.wrapResult(returnType, contents, pageable, result.getTotalHits().value);
    }

    private <R> R wrapResult(Class<R> returnType, List<Object> content, Pageable pageable, long total) {
        PageImpl rc = null;
        if (Page.class.isAssignableFrom(returnType)) {
            LOGGER.debug((Object)"Wrapping result in Page");
            rc = new PageImpl(content, pageable, total);
        } else {
            LOGGER.debug((Object)"Returning result as-is");
            rc = content;
        }
        return (R)rc;
    }
}

