/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.fragments;

import internal.org.springframework.content.fragments.EncryptingContentStoreConfiguration;
import internal.org.springframework.content.fragments.EncryptingContentStoreConfigurer;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.crypto.CipherInputStream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.fragments.ContentStoreAware;
import org.springframework.content.commons.io.RangeableResource;
import org.springframework.content.commons.mappingcontext.ContentProperty;
import org.springframework.content.commons.mappingcontext.MappingContext;
import org.springframework.content.commons.property.PropertyPath;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.GetResourceParams;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.repository.StoreAccessException;
import org.springframework.content.encryption.EnvelopeEncryptionService;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.data.util.Pair;
import org.springframework.util.Assert;

public class EncryptingContentStoreImpl<S, SID extends Serializable>
implements ContentStore<S, SID>,
ContentStoreAware {
    private MappingContext mappingContext = null;
    @Autowired
    private EnvelopeEncryptionService encrypter;
    @Autowired(required=false)
    private List<EncryptingContentStoreConfigurer> configurers;
    private String encryptionKeyContentProperty = "key";
    private String keyRing = "shared-key";
    private ContentStore delegate;
    private Class<?> domainClass;

    @Autowired
    public EncryptingContentStoreImpl(MappingContext mappingContext) {
        if (this.mappingContext == null) {
            this.mappingContext = new MappingContext((CharSequence)"/", (CharSequence)".");
        }
    }

    public S setContent(S o, InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    public S setContent(S o, PropertyPath propertyPath, InputStream inputStream) {
        Assert.notNull(o);
        Assert.notNull((Object)propertyPath);
        Assert.notNull((Object)inputStream);
        ContentProperty contentProperty = this.mappingContext.getContentProperty(o.getClass(), propertyPath.getName());
        if (contentProperty == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        Pair<CipherInputStream, byte[]> encryptionContext = this.encrypter.encrypt(inputStream, this.keyRing);
        contentProperty.setCustomProperty(o, this.encryptionKeyContentProperty, encryptionContext.getSecond());
        return (S)this.delegate.setContent(o, propertyPath, (InputStream)encryptionContext.getFirst());
    }

    public S setContent(S o, PropertyPath propertyPath, InputStream inputStream, long l) {
        Assert.notNull(o);
        Assert.notNull((Object)propertyPath);
        Assert.notNull((Object)inputStream);
        ContentProperty contentProperty = this.mappingContext.getContentProperty(o.getClass(), propertyPath.getName());
        if (contentProperty == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        Pair<CipherInputStream, byte[]> encryptionContext = this.encrypter.encrypt(inputStream, this.keyRing);
        contentProperty.setCustomProperty(o, this.encryptionKeyContentProperty, encryptionContext.getSecond());
        return (S)this.delegate.setContent(o, propertyPath, (InputStream)encryptionContext.getFirst(), l);
    }

    public S setContent(S o, Resource resource) {
        throw new UnsupportedOperationException();
    }

    public S setContent(S o, PropertyPath propertyPath, Resource resource) {
        Assert.notNull(o);
        Assert.notNull((Object)propertyPath);
        Assert.notNull((Object)resource);
        try {
            ContentProperty contentProperty = this.mappingContext.getContentProperty(o.getClass(), propertyPath.getName());
            if (contentProperty == null) {
                throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
            }
            Pair<CipherInputStream, byte[]> encryptionContext = null;
            encryptionContext = this.encrypter.encrypt(resource.getInputStream(), this.keyRing);
            contentProperty.setCustomProperty(o, this.encryptionKeyContentProperty, encryptionContext.getSecond());
            return (S)this.delegate.setContent(o, propertyPath, (Resource)new InputStreamResource((InputStream)encryptionContext.getFirst()));
        }
        catch (IOException e) {
            throw new StoreAccessException("error encrypting resource", (Throwable)e);
        }
    }

    public S unsetContent(S o) {
        throw new UnsupportedOperationException();
    }

    public S unsetContent(S o, PropertyPath propertyPath) {
        Assert.notNull(o);
        Assert.notNull((Object)propertyPath);
        ContentProperty contentProperty = this.mappingContext.getContentProperty(o.getClass(), propertyPath.getName());
        if (contentProperty == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        Object entityToReturn = this.delegate.unsetContent(o, propertyPath);
        contentProperty.setCustomProperty(o, this.encryptionKeyContentProperty, null);
        return (S)entityToReturn;
    }

    public InputStream getContent(S o) {
        throw new UnsupportedOperationException();
    }

    public InputStream getContent(S o, PropertyPath propertyPath) {
        Assert.notNull(o);
        Assert.notNull((Object)propertyPath);
        InputStream encryptedContentStream = this.delegate.getContent(o, propertyPath);
        InputStream unencryptedStream = null;
        if (encryptedContentStream != null) {
            ContentProperty contentProperty = this.mappingContext.getContentProperty(o.getClass(), propertyPath.getName());
            if (contentProperty == null) {
                throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
            }
            unencryptedStream = this.encrypter.decrypt((byte[])contentProperty.getCustomProperty(o, this.encryptionKeyContentProperty), encryptedContentStream, 0, this.keyRing);
        }
        return unencryptedStream;
    }

    public Resource getResource(S o) {
        throw new UnsupportedOperationException();
    }

    public Resource getResource(S o, PropertyPath propertyPath) {
        Assert.notNull(o);
        Assert.notNull((Object)propertyPath);
        Resource r = this.delegate.getResource(o, propertyPath);
        if (r != null) {
            InputStream unencryptedStream = null;
            try {
                ContentProperty contentProperty = this.mappingContext.getContentProperty(o.getClass(), propertyPath.getName());
                if (contentProperty == null) {
                    throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
                }
                unencryptedStream = this.encrypter.decrypt((byte[])contentProperty.getCustomProperty(o, this.encryptionKeyContentProperty), r.getInputStream(), 0, this.keyRing);
                r = new InputStreamResource((InputStream)new SkipInputStream(unencryptedStream));
            }
            catch (IOException e) {
                throw new StoreAccessException("error encrypting resource", (Throwable)e);
            }
        }
        return r;
    }

    public Resource getResource(S o, PropertyPath propertyPath, GetResourceParams params) {
        Assert.notNull(o);
        Assert.notNull((Object)propertyPath);
        GetResourceParams ctrParams = this.rewriteParamsForCTR(params);
        Resource r = this.delegate.getResource(o, propertyPath, ctrParams);
        if (r != null) {
            InputStream unencryptedStream = null;
            try {
                ContentProperty contentProperty = this.mappingContext.getContentProperty(o.getClass(), propertyPath.getName());
                if (contentProperty == null) {
                    throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
                }
                unencryptedStream = this.encrypter.decrypt((byte[])contentProperty.getCustomProperty(o, this.encryptionKeyContentProperty), r.getInputStream(), this.getOffset(r, params), this.keyRing);
                r = new InputStreamResource(unencryptedStream);
            }
            catch (IOException e) {
                throw new StoreAccessException("error encrypting resource", (Throwable)e);
            }
        }
        return r;
    }

    private GetResourceParams rewriteParamsForCTR(GetResourceParams params) {
        if (params.getRange() == null) {
            return params;
        }
        int begin = Integer.parseInt(StringUtils.substringBetween((String)params.getRange(), (String)"bytes=", (String)"-"));
        int blockBegin = begin - begin % 16;
        return GetResourceParams.builder().range("bytes=" + blockBegin + "-" + StringUtils.substringAfter((String)params.getRange(), (String)"-")).build();
    }

    private int getOffset(Resource r, GetResourceParams params) {
        int offset = 0;
        if (!(r instanceof RangeableResource)) {
            return offset;
        }
        if (params.getRange() == null) {
            return offset;
        }
        return Integer.parseInt(StringUtils.substringBetween((String)params.getRange(), (String)"bytes=", (String)"-"));
    }

    public void associate(S o, SID serializable) {
        throw new UnsupportedOperationException();
    }

    public void associate(S o, PropertyPath propertyPath, SID serializable) {
        this.associate(o, propertyPath, serializable);
    }

    public void unassociate(S o) {
        throw new UnsupportedOperationException();
    }

    public void unassociate(S o, PropertyPath propertyPath) {
        this.unassociate(o, propertyPath);
    }

    public Resource getResource(SID id) {
        throw new UnsupportedOperationException();
    }

    public void setDomainClass(Class<?> domainClass) {
        this.domainClass = domainClass;
    }

    public void setIdClass(Class<?> idClass) {
    }

    public void setContentStore(ContentStore store) {
        this.delegate = store;
    }

    public void setStoreInterfaceClass(Class<? extends Store> storeInterfaceClass) {
        this.configure(storeInterfaceClass);
    }

    private void configure(Class<? extends Store> storeInterfaceClass) {
        if (this.configurers == null) {
            return;
        }
        for (EncryptingContentStoreConfigurer configurer : this.configurers) {
            Type[] genericArguments;
            Optional<Type> interfaces = Arrays.stream(configurer.getClass().getGenericInterfaces()).findFirst();
            if (!interfaces.isPresent() || !((genericArguments = ((ParameterizedType)interfaces.get()).getActualTypeArguments()).length >= 1) || !genericArguments[0].equals(storeInterfaceClass)) continue;
            EncryptingContentStoreConfigurationImpl config = new EncryptingContentStoreConfigurationImpl();
            configurer.configure(config);
            this.encryptionKeyContentProperty = config.getEncryptionKeyContentProperty();
            this.keyRing = config.getKeyring();
        }
    }

    public class EncryptingContentStoreConfigurationImpl
    implements EncryptingContentStoreConfiguration {
        private String encryptionKeyContentProperty;
        private String keyring;

        @Override
        public EncryptingContentStoreConfiguration encryptionKeyContentProperty(String encryptionKeyContentProperty) {
            this.encryptionKeyContentProperty = encryptionKeyContentProperty;
            return this;
        }

        @Override
        public EncryptingContentStoreConfiguration keyring(String keyring) {
            this.keyring = keyring;
            return this;
        }

        String getEncryptionKeyContentProperty() {
            return this.encryptionKeyContentProperty;
        }

        String getKeyring() {
            return this.keyring;
        }
    }

    public class SkipInputStream
    extends FilterInputStream {
        private static final int MAX_SKIP_BUFFER_SIZE = 2048;

        protected SkipInputStream(InputStream in) {
            super(in);
        }

        @Override
        public long skip(long n) throws IOException {
            int nr;
            long remaining;
            if (n <= 0L) {
                return 0L;
            }
            int size = (int)Math.min(2048L, remaining);
            byte[] skipBuffer = new byte[size];
            for (remaining = n; remaining > 0L && (nr = this.in.read(skipBuffer, 0, (int)Math.min((long)size, remaining))) >= 0; remaining -= (long)nr) {
            }
            return n - remaining;
        }
    }
}

