/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.fragments;

import internal.org.springframework.content.fragments.EncryptingContentStoreConfiguration;
import internal.org.springframework.content.fragments.EncryptingContentStoreConfigurer;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.crypto.CipherInputStream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.fragments.ContentStoreAware;
import org.springframework.content.commons.io.RangeableResource;
import org.springframework.content.commons.mappingcontext.ContentProperty;
import org.springframework.content.commons.mappingcontext.MappingContext;
import org.springframework.content.commons.property.PropertyPath;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.repository.StoreAccessException;
import org.springframework.content.commons.repository.UnsetContentParams;
import org.springframework.content.commons.store.GetResourceParams;
import org.springframework.content.commons.store.SetContentParams;
import org.springframework.content.commons.store.UnsetContentParams;
import org.springframework.content.commons.utils.AssertUtils;
import org.springframework.content.encryption.EnvelopeEncryptionService;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.data.util.Pair;
import org.springframework.util.Assert;

public class EncryptingContentStoreImpl<S, SID extends Serializable>
implements ContentStore<S, SID>,
org.springframework.content.commons.store.ContentStore<S, SID>,
ContentStoreAware {
    @Autowired(required=false)
    private MappingContext mappingContext = null;
    @Autowired
    private EnvelopeEncryptionService encrypter;
    @Autowired(required=false)
    private List<EncryptingContentStoreConfigurer> configurers;
    private String encryptionKeyContentProperty = "key";
    private String keyRing = "shared-key";
    private ContentStore delegate;
    private org.springframework.content.commons.store.ContentStore storeDelegate;
    private Class<?> domainClass;

    protected MappingContext getMappingContext() {
        if (this.mappingContext == null) {
            this.mappingContext = new MappingContext((CharSequence)"/", (CharSequence)".");
        }
        return this.mappingContext;
    }

    public S setContent(S o, InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    public S setContent(S entity, PropertyPath propertyPath, InputStream content) {
        Assert.notNull(entity, (String)"entity not set");
        Assert.notNull((Object)propertyPath, (String)"propertyPath not set");
        Assert.notNull((Object)content, (String)"content not set");
        AssertUtils.atLeastOneNotNull((Object[])new Object[]{this.storeDelegate, this.delegate}, (String)"store not set");
        ContentProperty contentProperty = this.getMappingContext().getContentProperty(entity.getClass(), propertyPath.getName());
        if (contentProperty == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        Pair<CipherInputStream, byte[]> encryptionContext = this.encrypter.encrypt(content, this.keyRing);
        contentProperty.setCustomProperty(entity, this.encryptionKeyContentProperty, encryptionContext.getSecond());
        if (this.storeDelegate != null) {
            return (S)this.storeDelegate.setContent(entity, propertyPath, (InputStream)encryptionContext.getFirst());
        }
        if (this.delegate != null) {
            return (S)this.delegate.setContent(entity, propertyPath, (InputStream)encryptionContext.getFirst());
        }
        throw new IllegalStateException("no store set");
    }

    public S setContent(S entity, PropertyPath propertyPath, InputStream inputStream, long l) {
        AssertUtils.atLeastOneNotNull((Object[])new Object[]{this.storeDelegate, this.delegate}, (String)"store not set");
        if (this.storeDelegate != null) {
            return this.setContent(entity, propertyPath, inputStream, SetContentParams.builder().contentLength(l).build());
        }
        return this.setContent(entity, propertyPath, inputStream, org.springframework.content.commons.repository.SetContentParams.builder().contentLength(l).build());
    }

    public S setContent(S entity, PropertyPath propertyPath, InputStream content, org.springframework.content.commons.repository.SetContentParams params) {
        Assert.notNull(entity, (String)"entity not set");
        Assert.notNull((Object)propertyPath, (String)"propertyPath not set");
        Assert.notNull((Object)content, (String)"content not set");
        Assert.notNull((Object)params, (String)"params not set");
        Assert.notNull((Object)this.delegate, (String)"store not set");
        ContentProperty contentProperty = this.getMappingContext().getContentProperty(entity.getClass(), propertyPath.getName());
        if (contentProperty == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        Pair<CipherInputStream, byte[]> encryptionContext = this.encrypter.encrypt(content, this.keyRing);
        contentProperty.setCustomProperty(entity, this.encryptionKeyContentProperty, encryptionContext.getSecond());
        return (S)this.delegate.setContent(entity, propertyPath, (InputStream)encryptionContext.getFirst(), params);
    }

    public S setContent(S entity, PropertyPath propertyPath, InputStream content, SetContentParams params) {
        Assert.notNull(entity, (String)"entity not set");
        Assert.notNull((Object)propertyPath, (String)"propertyPath not set");
        Assert.notNull((Object)content, (String)"content not set");
        Assert.notNull((Object)params, (String)"params not set");
        Assert.notNull((Object)this.storeDelegate, (String)"store not set");
        ContentProperty contentProperty = this.getMappingContext().getContentProperty(entity.getClass(), propertyPath.getName());
        if (contentProperty == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        Pair<CipherInputStream, byte[]> encryptionContext = this.encrypter.encrypt(content, this.keyRing);
        contentProperty.setCustomProperty(entity, this.encryptionKeyContentProperty, encryptionContext.getSecond());
        return (S)this.storeDelegate.setContent(entity, propertyPath, (InputStream)encryptionContext.getFirst(), params);
    }

    public S setContent(S o, Resource resource) {
        throw new UnsupportedOperationException();
    }

    public S setContent(S entity, PropertyPath propertyPath, Resource resource) {
        Assert.notNull(entity, (String)"entity not set");
        Assert.notNull((Object)propertyPath, (String)"propertyPath not set");
        Assert.notNull((Object)resource, (String)"resource not set");
        AssertUtils.atLeastOneNotNull((Object[])new Object[]{this.storeDelegate, this.delegate}, (String)"store not set");
        try {
            ContentProperty contentProperty = this.getMappingContext().getContentProperty(entity.getClass(), propertyPath.getName());
            if (contentProperty == null) {
                throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
            }
            Pair<CipherInputStream, byte[]> encryptionContext = null;
            encryptionContext = this.encrypter.encrypt(resource.getInputStream(), this.keyRing);
            contentProperty.setCustomProperty(entity, this.encryptionKeyContentProperty, encryptionContext.getSecond());
            if (this.storeDelegate != null) {
                return (S)this.delegate.setContent(entity, propertyPath, (Resource)new InputStreamResource((InputStream)encryptionContext.getFirst()));
            }
            return (S)this.delegate.setContent(entity, propertyPath, (Resource)new InputStreamResource((InputStream)encryptionContext.getFirst()));
        }
        catch (IOException e) {
            throw new StoreAccessException("error encrypting resource", (Throwable)e);
        }
    }

    public S unsetContent(S o) {
        throw new UnsupportedOperationException();
    }

    public S unsetContent(S entity, PropertyPath propertyPath) {
        return this.unsetContent(entity, propertyPath, org.springframework.content.commons.store.UnsetContentParams.builder().build());
    }

    public S unsetContent(S entity, PropertyPath propertyPath, UnsetContentParams params) {
        int ordinal = params.getDisposition().ordinal();
        org.springframework.content.commons.store.UnsetContentParams params1 = org.springframework.content.commons.store.UnsetContentParams.builder().disposition(UnsetContentParams.Disposition.values()[ordinal]).build();
        return this.unsetContent(entity, propertyPath, params1);
    }

    public S unsetContent(S entity, PropertyPath propertyPath, org.springframework.content.commons.store.UnsetContentParams params) {
        Assert.notNull(entity, (String)"entity not set");
        Assert.notNull((Object)propertyPath, (String)"propertyPath not set");
        AssertUtils.atLeastOneNotNull((Object[])new Object[]{this.storeDelegate, this.delegate}, (String)"store not set");
        ContentProperty contentProperty = this.getMappingContext().getContentProperty(entity.getClass(), propertyPath.getName());
        if (contentProperty == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        Object entityToReturn = null;
        if (this.storeDelegate != null) {
            entityToReturn = this.storeDelegate.unsetContent(entity, propertyPath, params);
        } else if (this.delegate != null) {
            int ordinal = params.getDisposition().ordinal();
            UnsetContentParams params1 = UnsetContentParams.builder().disposition(UnsetContentParams.Disposition.values()[ordinal]).build();
            entityToReturn = this.delegate.unsetContent(entity, propertyPath, params1);
        }
        contentProperty.setCustomProperty(entity, this.encryptionKeyContentProperty, null);
        return (S)entityToReturn;
    }

    public InputStream getContent(S o) {
        throw new UnsupportedOperationException();
    }

    public InputStream getContent(S entity, PropertyPath propertyPath) {
        Assert.notNull(entity, (String)"entity not set");
        Assert.notNull((Object)propertyPath, (String)"propertyPath not set");
        AssertUtils.atLeastOneNotNull((Object[])new Object[]{this.storeDelegate, this.delegate}, (String)"store not set");
        InputStream encryptedContentStream = null;
        if (this.storeDelegate != null) {
            encryptedContentStream = this.delegate.getContent(entity, propertyPath);
        } else if (this.delegate != null) {
            encryptedContentStream = this.delegate.getContent(entity, propertyPath);
        }
        InputStream unencryptedStream = null;
        if (encryptedContentStream != null) {
            ContentProperty contentProperty = this.getMappingContext().getContentProperty(entity.getClass(), propertyPath.getName());
            if (contentProperty == null) {
                throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
            }
            unencryptedStream = this.encrypter.decrypt((byte[])contentProperty.getCustomProperty(entity, this.encryptionKeyContentProperty), encryptedContentStream, 0, this.keyRing);
        }
        return unencryptedStream;
    }

    public Resource getResource(S o) {
        throw new UnsupportedOperationException();
    }

    public Resource getResource(S entity, PropertyPath propertyPath) {
        Assert.notNull(entity, (String)"entity not set");
        Assert.notNull((Object)propertyPath, (String)"propertyPath not set");
        AssertUtils.atLeastOneNotNull((Object[])new Object[]{this.storeDelegate, this.delegate}, (String)"store not set");
        Resource r = null;
        if (this.storeDelegate != null) {
            r = this.storeDelegate.getResource(entity, propertyPath);
        } else if (this.delegate != null) {
            r = this.delegate.getResource(entity, propertyPath);
        }
        if (r != null) {
            InputStream unencryptedStream = null;
            try {
                ContentProperty contentProperty = this.getMappingContext().getContentProperty(entity.getClass(), propertyPath.getName());
                if (contentProperty == null) {
                    throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
                }
                unencryptedStream = this.encrypter.decrypt((byte[])contentProperty.getCustomProperty(entity, this.encryptionKeyContentProperty), r.getInputStream(), 0, this.keyRing);
                r = new InputStreamResource((InputStream)new SkipInputStream(unencryptedStream));
            }
            catch (IOException e) {
                throw new StoreAccessException("error encrypting resource", (Throwable)e);
            }
        }
        return r;
    }

    public Resource getResource(S entity, PropertyPath propertyPath, GetResourceParams params) {
        Assert.notNull(entity, (String)"entity not set");
        Assert.notNull((Object)propertyPath, (String)"propertyPath not set");
        Assert.notNull((Object)this.storeDelegate, (String)"store not set");
        Resource r = this.storeDelegate.getResource(entity, propertyPath, this.rewriteParamsForCTR(params));
        if (r != null) {
            InputStream unencryptedStream = null;
            try {
                ContentProperty contentProperty = this.getMappingContext().getContentProperty(entity.getClass(), propertyPath.getName());
                if (contentProperty == null) {
                    throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
                }
                unencryptedStream = this.encrypter.decrypt((byte[])contentProperty.getCustomProperty(entity, this.encryptionKeyContentProperty), r.getInputStream(), this.getOffset(r, params), this.keyRing);
                r = new InputStreamResource(unencryptedStream);
            }
            catch (IOException e) {
                throw new StoreAccessException("error encrypting resource", (Throwable)e);
            }
        }
        return r;
    }

    public Resource getResource(S entity, PropertyPath propertyPath, org.springframework.content.commons.repository.GetResourceParams params) {
        Assert.notNull(entity, (String)"entity not set");
        Assert.notNull((Object)propertyPath, (String)"propertyPath not set");
        Assert.notNull((Object)this.delegate, (String)"store not set");
        Resource r = this.delegate.getResource(entity, propertyPath, this.rewriteParamsForCTR(params));
        if (r != null) {
            InputStream unencryptedStream = null;
            try {
                ContentProperty contentProperty = this.getMappingContext().getContentProperty(entity.getClass(), propertyPath.getName());
                if (contentProperty == null) {
                    throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
                }
                unencryptedStream = this.encrypter.decrypt((byte[])contentProperty.getCustomProperty(entity, this.encryptionKeyContentProperty), r.getInputStream(), this.getOffset(r, params), this.keyRing);
                r = new InputStreamResource(unencryptedStream);
            }
            catch (IOException e) {
                throw new StoreAccessException("error encrypting resource", (Throwable)e);
            }
        }
        return r;
    }

    private org.springframework.content.commons.repository.GetResourceParams rewriteParamsForCTR(org.springframework.content.commons.repository.GetResourceParams params) {
        if (params.getRange() == null) {
            return params;
        }
        int begin = Integer.parseInt(StringUtils.substringBetween((String)params.getRange(), (String)"bytes=", (String)"-"));
        int blockBegin = begin - begin % 16;
        return org.springframework.content.commons.repository.GetResourceParams.builder().range("bytes=" + blockBegin + "-" + StringUtils.substringAfter((String)params.getRange(), (String)"-")).build();
    }

    private GetResourceParams rewriteParamsForCTR(GetResourceParams params) {
        if (params.getRange() == null) {
            return params;
        }
        int begin = Integer.parseInt(StringUtils.substringBetween((String)params.getRange(), (String)"bytes=", (String)"-"));
        int blockBegin = begin - begin % 16;
        return GetResourceParams.builder().range("bytes=" + blockBegin + "-" + StringUtils.substringAfter((String)params.getRange(), (String)"-")).build();
    }

    private int getOffset(Resource r, org.springframework.content.commons.repository.GetResourceParams params) {
        int offset = 0;
        if (!(r instanceof RangeableResource)) {
            return offset;
        }
        if (params.getRange() == null) {
            return offset;
        }
        return Integer.parseInt(StringUtils.substringBetween((String)params.getRange(), (String)"bytes=", (String)"-"));
    }

    private int getOffset(Resource r, GetResourceParams params) {
        int offset = 0;
        if (!(r instanceof RangeableResource)) {
            return offset;
        }
        if (params.getRange() == null) {
            return offset;
        }
        return Integer.parseInt(StringUtils.substringBetween((String)params.getRange(), (String)"bytes=", (String)"-"));
    }

    public void associate(S o, SID serializable) {
        throw new UnsupportedOperationException();
    }

    public void associate(S o, PropertyPath propertyPath, SID serializable) {
        this.associate(o, propertyPath, serializable);
    }

    public void unassociate(S o) {
        throw new UnsupportedOperationException();
    }

    public void unassociate(S o, PropertyPath propertyPath) {
        this.unassociate(o, propertyPath);
    }

    public Resource getResource(SID id) {
        throw new UnsupportedOperationException();
    }

    public void setDomainClass(Class<?> domainClass) {
        this.domainClass = domainClass;
    }

    public void setIdClass(Class<?> idClass) {
    }

    public void setContentStore(ContentStore store) {
        this.delegate = store;
    }

    public void setContentStore(org.springframework.content.commons.store.ContentStore store) {
        this.storeDelegate = store;
    }

    public void setStoreInterfaceClass(Class<? extends Store> storeInterfaceClass) {
        this.configure(storeInterfaceClass);
    }

    private void configure(Class<? extends Store> storeInterfaceClass) {
        if (this.configurers == null) {
            return;
        }
        for (EncryptingContentStoreConfigurer configurer : this.configurers) {
            Type[] genericArguments;
            Optional<Type> interfaces = Arrays.stream(configurer.getClass().getGenericInterfaces()).findFirst();
            if (!interfaces.isPresent() || !((genericArguments = ((ParameterizedType)interfaces.get()).getActualTypeArguments()).length >= 1) || !genericArguments[0].equals(storeInterfaceClass)) continue;
            EncryptingContentStoreConfigurationImpl config = new EncryptingContentStoreConfigurationImpl();
            configurer.configure(config);
            this.encryptionKeyContentProperty = config.getEncryptionKeyContentProperty();
            this.keyRing = config.getKeyring();
        }
    }

    public class SkipInputStream
    extends FilterInputStream {
        private static final int MAX_SKIP_BUFFER_SIZE = 2048;

        protected SkipInputStream(InputStream in) {
            super(in);
        }

        @Override
        public long skip(long n) throws IOException {
            int nr;
            long remaining;
            if (n <= 0L) {
                return 0L;
            }
            int size = (int)Math.min(2048L, remaining);
            byte[] skipBuffer = new byte[size];
            for (remaining = n; remaining > 0L && (nr = this.in.read(skipBuffer, 0, (int)Math.min((long)size, remaining))) >= 0; remaining -= (long)nr) {
            }
            return n - remaining;
        }
    }

    public class EncryptingContentStoreConfigurationImpl
    implements EncryptingContentStoreConfiguration {
        private String encryptionKeyContentProperty;
        private String keyring;

        @Override
        public EncryptingContentStoreConfiguration encryptionKeyContentProperty(String encryptionKeyContentProperty) {
            this.encryptionKeyContentProperty = encryptionKeyContentProperty;
            return this;
        }

        @Override
        public EncryptingContentStoreConfiguration keyring(String keyring) {
            this.keyring = keyring;
            return this;
        }

        String getEncryptionKeyContentProperty() {
            return this.encryptionKeyContentProperty;
        }

        String getKeyring() {
            return this.keyring;
        }
    }
}

