/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.encryption;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.data.util.Pair;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.VaultTransitOperations;

public class EnvelopeEncryptionService {
    private static KeyGenerator KEY_GENERATOR;
    private static String transformation;
    private static final String AES = "AES";
    private final VaultOperations vaultOperations;
    private final SecureRandom secureRandom = new SecureRandom();

    public EnvelopeEncryptionService(VaultOperations vaultOperations) {
        this.vaultOperations = vaultOperations;
    }

    private CipherInputStream encryptMessage(InputStream is, SecretKey dataKey, byte[] nonce) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance(transformation);
        SecretKeySpec key = new SecretKeySpec(dataKey.getEncoded(), AES);
        byte[] iv = new byte[16];
        System.arraycopy(nonce, 0, iv, 0, nonce.length);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)key, ivSpec);
        CipherInputStream cis = new CipherInputStream(is, cipher);
        return cis;
    }

    public Pair<CipherInputStream, byte[]> encrypt(InputStream is, String keyName) {
        try {
            SecretKey key = this.generateDataKey();
            byte[] nonce = new byte[12];
            this.secureRandom.nextBytes(nonce);
            VaultTransitOperations transit = this.vaultOperations.opsForTransit();
            String base64Encoded = Base64.getEncoder().encodeToString(key.getEncoded());
            transit.createKey(keyName);
            String ciphertext = transit.encrypt(keyName, base64Encoded);
            byte[] encryptionContext = new byte[117];
            System.arraycopy(ciphertext.getBytes("UTF-8"), 0, encryptionContext, 0, 105);
            System.arraycopy(nonce, 0, encryptionContext, 105, 12);
            return Pair.of((Object)this.encryptMessage(is, key, nonce), (Object)encryptionContext);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to encrypt", e);
        }
    }

    private SecretKey generateDataKey() {
        return KEY_GENERATOR.generateKey();
    }

    private InputStream decryptInputStream(SecretKeySpec secretKeySpec, byte[] nonce, int offset, InputStream is) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, IOException, InvalidAlgorithmParameterException {
        CipherInputStream cis;
        IvParameterSpec ivForOffset;
        Cipher cipher = Cipher.getInstance(transformation);
        byte[] iv = new byte[16];
        System.arraycopy(nonce, 0, iv, 0, nonce.length);
        int AES_BLOCK_SIZE = 16;
        int blockOffset = offset - offset % AES_BLOCK_SIZE;
        BigInteger ivBI = new BigInteger(1, iv);
        BigInteger ivForOffsetBI = ivBI.add(BigInteger.valueOf(blockOffset / AES_BLOCK_SIZE));
        byte[] ivForOffsetBA = ivForOffsetBI.toByteArray();
        if (ivForOffsetBA.length >= AES_BLOCK_SIZE) {
            ivForOffset = new IvParameterSpec(ivForOffsetBA, ivForOffsetBA.length - AES_BLOCK_SIZE, AES_BLOCK_SIZE);
        } else {
            byte[] ivForOffsetBASized = new byte[AES_BLOCK_SIZE];
            System.arraycopy(ivForOffsetBA, 0, ivForOffsetBASized, AES_BLOCK_SIZE - ivForOffsetBA.length, ivForOffsetBA.length);
            ivForOffset = new IvParameterSpec(ivForOffsetBASized);
        }
        cipher.init(1, (Key)secretKeySpec, ivForOffset);
        FilterInputStream inputStreamToReturn = cis = new CipherInputStream(is, cipher);
        if (offset == 0) {
            inputStreamToReturn = new ZeroOffsetSkipInputStream(cis);
        } else if (offset > 0) {
            inputStreamToReturn = new OffsetSkipInputStream(cis, offset % AES_BLOCK_SIZE);
        }
        return inputStreamToReturn;
    }

    private SecretKeySpec decryptKey(byte[] encryptedKey, String keyName) {
        VaultTransitOperations transit = this.vaultOperations.opsForTransit();
        String decryptedBase64Key = transit.decrypt(keyName, new String(encryptedKey));
        byte[] keyBytes = Base64.getDecoder().decode(decryptedBase64Key);
        SecretKeySpec key = new SecretKeySpec(keyBytes, AES);
        return key;
    }

    public InputStream decrypt(byte[] ecryptedContext, InputStream is, int offset, String keyName) {
        byte[] key = new byte[105];
        System.arraycopy(ecryptedContext, 0, key, 0, 105);
        byte[] nonce = new byte[12];
        System.arraycopy(ecryptedContext, 105, nonce, 0, 12);
        try {
            SecretKeySpec keySpec = this.decryptKey(key, keyName);
            return this.decryptInputStream(keySpec, nonce, offset, is);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to decrypt", e);
        }
    }

    public void rotate(String keyName) {
        VaultTransitOperations transit = this.vaultOperations.opsForTransit();
        transit.rotate(keyName);
    }

    static {
        transformation = "AES/CTR/NoPadding";
        try {
            KEY_GENERATOR = KeyGenerator.getInstance(AES);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        KEY_GENERATOR.init(256, new SecureRandom());
    }

    public class ZeroOffsetSkipInputStream
    extends FilterInputStream {
        private static final int MAX_SKIP_BUFFER_SIZE = 2048;

        protected ZeroOffsetSkipInputStream(InputStream in) {
            super(in);
        }

        @Override
        public long skip(long n) throws IOException {
            int nr;
            long remaining;
            if (n <= 0L) {
                return 0L;
            }
            int size = (int)Math.min(2048L, remaining);
            byte[] skipBuffer = new byte[size];
            for (remaining = n; remaining > 0L && (nr = this.in.read(skipBuffer, 0, (int)Math.min((long)size, remaining))) >= 0; remaining -= (long)nr) {
            }
            return n - remaining;
        }
    }

    public class OffsetSkipInputStream
    extends FilterInputStream {
        private static final int MAX_SKIP_BUFFER_SIZE = 2048;
        private final int offset;

        protected OffsetSkipInputStream(InputStream in, int offset) {
            super(in);
            this.offset = offset;
        }

        @Override
        public long skip(long n) throws IOException {
            int nr;
            long remaining;
            if (n <= 0L) {
                return 0L;
            }
            int size = (int)Math.min(2048L, remaining);
            byte[] skipBuffer = new byte[size];
            for (remaining = (long)this.offset; remaining > 0L && (nr = this.in.read(skipBuffer, 0, (int)Math.min((long)size, remaining))) >= 0; remaining -= (long)nr) {
            }
            return n - remaining;
        }
    }
}

