/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.fs.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;

public class FilesystemProperties {
    private static Log logger = LogFactory.getLog(FilesystemProperties.class);
    private String filesystemRoot;

    public String getFilesystemRoot() {
        if (this.filesystemRoot == null) {
            try {
                this.filesystemRoot = Files.createTempDirectory("", new FileAttribute[0]).toString();
                logger.info((Object)String.format("Defaulting filesystem root to %s", this.filesystemRoot));
            }
            catch (IOException e) {
                logger.error((Object)String.format("Unexpected error defaulting filesystem root to %s", this.filesystemRoot));
            }
        }
        return this.filesystemRoot;
    }

    @Value(value="${spring.content.fs.filesystemRoot:#{null}}")
    public void setFilesystemRoot(String filesystemRoot) {
        this.filesystemRoot = filesystemRoot;
    }
}

