/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.fs.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.content.commons.io.DeletableResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;

public class FileSystemDeletableResource
implements WritableResource,
DeletableResource {
    private static Log logger = LogFactory.getLog(FileSystemDeletableResource.class);
    private FileSystemResource resource;

    public FileSystemDeletableResource(FileSystemResource resource) {
        this.resource = resource;
    }

    public void delete() {
        try {
            FileUtils.forceDelete((File)this.getFile());
        }
        catch (IOException ioe) {
            logger.debug((Object)String.format("Unexpected error deleting resource %s", this), (Throwable)ioe);
        }
    }

    public boolean isOpen() {
        return this.resource.isOpen();
    }

    public final String getPath() {
        return this.resource.getPath();
    }

    public boolean exists() {
        return this.resource.exists();
    }

    public boolean isReadable() {
        return this.resource.isReadable();
    }

    public InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }

    public boolean isWritable() {
        return this.resource.isWritable();
    }

    public long lastModified() throws IOException {
        return this.resource.lastModified();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.resource.getOutputStream();
    }

    public URL getURL() throws IOException {
        return this.resource.getURL();
    }

    public URI getURI() throws IOException {
        return this.resource.getURI();
    }

    public File getFile() {
        return this.resource.getFile();
    }

    public long contentLength() throws IOException {
        return this.resource.contentLength();
    }

    public Resource createRelative(String relativePath) {
        return this.resource.createRelative(relativePath);
    }

    public String toString() {
        return this.resource.toString();
    }

    public String getFilename() {
        return this.resource.getFilename();
    }

    public String getDescription() {
        return this.resource.getDescription();
    }

    public boolean equals(Object obj) {
        return this.resource.equals(obj);
    }

    public int hashCode() {
        return this.resource.hashCode();
    }
}

