/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.fs.io;

import org.springframework.content.fs.io.FileSystemDeletableResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FileSystemResourceLoader
extends org.springframework.core.io.FileSystemResourceLoader {
    private FileSystemResource root;

    public FileSystemResourceLoader(String root) {
        Assert.notNull((Object)root);
        this.root = new FileSystemResource(this.suffixPath(StringUtils.cleanPath((String)root)));
    }

    private String suffixPath(String path) {
        if (!path.endsWith("/")) {
            return path + "/";
        }
        return path;
    }

    public Resource getResource(String location) {
        Assert.notNull((Object)this.root);
        Object resource = this.root.createRelative(location);
        if (resource instanceof FileSystemResource) {
            resource = new FileSystemDeletableResource((FileSystemResource)resource);
        }
        return resource;
    }
}

