/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.fs.config;

import internal.org.springframework.content.fs.repository.DefaultFilesystemStoreImpl;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.mappingcontext.MappingContext;
import org.springframework.content.commons.repository.factory.AbstractStoreFactoryBean;
import org.springframework.content.commons.utils.FileService;
import org.springframework.content.commons.utils.FileServiceImpl;
import org.springframework.content.commons.utils.PlacementService;
import org.springframework.content.fs.io.FileSystemResourceLoader;
import org.springframework.util.Assert;
import org.springframework.versions.LockingAndVersioningProxyFactory;

public class FilesystemStoreFactoryBean
extends AbstractStoreFactoryBean {
    @Autowired
    FileSystemResourceLoader loader;
    @Autowired
    PlacementService filesystemStorePlacementService;
    @Autowired(required=false)
    private LockingAndVersioningProxyFactory versioning;
    @Autowired(required=false)
    private MappingContext mappingContext;

    protected void addProxyAdvice(ProxyFactory result, BeanFactory beanFactory) {
        if (this.versioning != null) {
            this.versioning.apply(result);
        }
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)((Object)this.loader), (String)"resource loader cannot be null");
        Assert.notNull((Object)this.filesystemStorePlacementService, (String)"filesystemStorePlacementService cannot be null");
    }

    protected Object getContentStoreImpl() {
        return new DefaultFilesystemStoreImpl(this.loader, this.mappingContext, this.filesystemStorePlacementService, (FileService)new FileServiceImpl());
    }
}

