/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.fs.store;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.annotations.ContentLength;
import org.springframework.content.commons.io.DeletableResource;
import org.springframework.content.commons.mappingcontext.ContentProperty;
import org.springframework.content.commons.mappingcontext.MappingContext;
import org.springframework.content.commons.property.PropertyPath;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.store.GetResourceParams;
import org.springframework.content.commons.store.StoreAccessException;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.commons.utils.Condition;
import org.springframework.content.commons.utils.FileService;
import org.springframework.content.commons.utils.PlacementService;
import org.springframework.content.fs.io.FileSystemResourceLoader;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional(readOnly=true)
public class DefaultFilesystemStoreImpl<S, SID extends Serializable>
implements Store<SID>,
AssociativeStore<S, SID>,
ContentStore<S, SID>,
org.springframework.content.commons.store.AssociativeStore<S, SID> {
    private static Log logger = LogFactory.getLog(DefaultFilesystemStoreImpl.class);
    private FileSystemResourceLoader loader;
    private PlacementService placer;
    private FileService fileService;
    private MappingContext mappingContext;

    public DefaultFilesystemStoreImpl(FileSystemResourceLoader loader, MappingContext mappingContext, PlacementService conversion, FileService fileService) {
        this.loader = loader;
        this.placer = conversion;
        this.fileService = fileService;
        this.mappingContext = mappingContext;
        if (this.mappingContext == null) {
            this.mappingContext = new MappingContext((CharSequence)"/", (CharSequence)".");
        }
    }

    public Resource getResource(SID id) {
        String location = (String)this.placer.convert(id, String.class);
        Resource resource = this.loader.getResource(location);
        return resource;
    }

    public Resource getResource(S entity) {
        String location;
        Resource resource = null;
        if (this.placer.canConvert(entity.getClass(), String.class) && (resource = this.loader.getResource(location = (String)this.placer.convert(entity, String.class))) != null) {
            return resource;
        }
        Serializable contentId = (Serializable)BeanUtils.getFieldWithAnnotation(entity, ContentId.class);
        if (contentId != null) {
            return this.getResource((S)contentId);
        }
        return null;
    }

    public Resource getResource(S entity, PropertyPath propertyPath) {
        return this.getResource(entity, propertyPath, GetResourceParams.builder().build());
    }

    public Resource getResource(S entity, PropertyPath propertyPath, GetResourceParams params) {
        ContentProperty contentProperty = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (contentProperty == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        Serializable contentId = (Serializable)contentProperty.getContentId(entity);
        if (contentId == null) {
            return null;
        }
        return this.getResource((S)contentId);
    }

    public Resource getResource(S entity, PropertyPath propertyPath, org.springframework.content.commons.repository.GetResourceParams params) {
        ContentProperty contentProperty = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (contentProperty == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        Serializable contentId = (Serializable)contentProperty.getContentId(entity);
        if (contentId == null) {
            return null;
        }
        return this.getResource((S)contentId);
    }

    public void associate(S entity, SID id) {
        BeanUtils.setFieldWithAnnotation(entity, ContentId.class, (Object)id.toString());
    }

    public void associate(S entity, PropertyPath propertyPath, SID id) {
        this.setContentId(entity, propertyPath, id, null);
    }

    public void unassociate(S entity) {
        BeanUtils.setFieldWithAnnotationConditionally(entity, ContentId.class, null, (Condition)new Condition(){

            public boolean matches(Field field) {
                for (Annotation annotation : field.getAnnotations()) {
                    if (!"jakarta.persistence.Id".equals(annotation.annotationType().getCanonicalName()) && !"org.springframework.data.annotation.Id".equals(annotation.annotationType().getCanonicalName())) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public void unassociate(S entity, PropertyPath propertyPath) {
        this.setContentId(entity, propertyPath, null, new Condition(){

            public boolean matches(Field field) {
                for (Annotation annotation : field.getAnnotations()) {
                    if (!"javax.persistence.Id".equals(annotation.annotationType().getCanonicalName()) && !"org.springframework.data.annotation.Id".equals(annotation.annotationType().getCanonicalName())) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Transactional
    public S setContent(S entity, InputStream content) {
        Resource resource;
        Object contentId = BeanUtils.getFieldWithAnnotation(entity, ContentId.class);
        if (contentId == null) {
            String newId = UUID.randomUUID().toString();
            Object convertedId = this.convertToExternalContentIdType(entity, newId);
            BeanUtils.setFieldWithAnnotation(entity, ContentId.class, (Object)convertedId);
        }
        if ((resource = this.getResource(entity)) == null) {
            return entity;
        }
        OutputStream os = null;
        try {
            if (!resource.exists()) {
                File resourceFile = resource.getFile();
                File parent = resourceFile.getParentFile();
                this.fileService.mkdirs(parent);
            }
            if (resource instanceof WritableResource) {
                os = ((WritableResource)resource).getOutputStream();
                IOUtils.copy((InputStream)content, (OutputStream)os);
            }
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected io error setting content for entity %s", entity), (Throwable)e);
            throw new StoreAccessException(String.format("Setting content for entity %s", entity), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)String.format("Unexpected error setting content for entity %s", entity), (Throwable)e);
            throw new StoreAccessException(String.format("Setting content for entity %s", entity), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(os);
        }
        try {
            BeanUtils.setFieldWithAnnotation(entity, ContentLength.class, (Object)resource.contentLength());
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error setting content length for content for resource %s", resource.toString()), (Throwable)e);
        }
        return entity;
    }

    @Transactional
    public S setContent(S property, PropertyPath propertyPath, InputStream content) {
        return this.setContent(property, propertyPath, content, -1L);
    }

    @Transactional
    public S setContent(S property, PropertyPath propertyPath, InputStream content, long contentLen) {
        Resource resource;
        ContentProperty contentProperty = this.mappingContext.getContentProperty(property.getClass(), propertyPath.getName());
        if (contentProperty == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        Object contentId = contentProperty.getContentId(property);
        if (contentId == null) {
            String newId = UUID.randomUUID().toString();
            Object convertedId = this.placer.convert((Object)newId, TypeDescriptor.forObject((Object)newId), contentProperty.getContentIdType(property));
            contentProperty.setContentId(property, convertedId, null);
        }
        if ((resource = this.getResource(property, propertyPath)) == null) {
            return property;
        }
        OutputStream os = null;
        try {
            if (!resource.exists()) {
                File resourceFile = resource.getFile();
                File parent = resourceFile.getParentFile();
                this.fileService.mkdirs(parent);
            }
            if (resource instanceof WritableResource) {
                os = ((WritableResource)resource).getOutputStream();
                IOUtils.copy((InputStream)content, (OutputStream)os);
            }
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected io error setting content for entity %s", property), (Throwable)e);
            throw new StoreAccessException(String.format("Setting content for entity %s", property), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)String.format("Unexpected error setting content for entity %s", property), (Throwable)e);
            throw new StoreAccessException(String.format("Setting content for entity %s", property), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(os);
        }
        try {
            long len = contentLen;
            if (len == -1L) {
                len = resource.contentLength();
            }
            contentProperty.setContentLength(property, (Object)len);
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error setting content length for content for resource %s", resource.toString()), (Throwable)e);
        }
        return property;
    }

    @Transactional
    public S setContent(S property, Resource resourceContent) {
        try {
            return this.setContent(property, resourceContent.getInputStream());
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error setting content for entity %s", property), (Throwable)e);
            throw new StoreAccessException(String.format("Setting content for entity %s", property), (Throwable)e);
        }
    }

    @Transactional
    public S setContent(S property, PropertyPath propertyPath, Resource resourceContent) {
        try {
            return this.setContent(property, propertyPath, resourceContent.getInputStream());
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error setting content for entity %s", property), (Throwable)e);
            throw new StoreAccessException(String.format("Setting content for entity %s", property), (Throwable)e);
        }
    }

    @Transactional
    public InputStream getContent(S entity) {
        if (entity == null) {
            return null;
        }
        Resource resource = this.getResource(entity);
        try {
            if (resource != null && resource.exists()) {
                return resource.getInputStream();
            }
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error getting content for entity %s", entity), (Throwable)e);
            throw new StoreAccessException(String.format("Getting content for entity %s", entity), (Throwable)e);
        }
        return null;
    }

    @Transactional
    public InputStream getContent(S property, PropertyPath propertyPath) {
        if (property == null) {
            return null;
        }
        Resource resource = this.getResource(property, propertyPath);
        try {
            if (resource != null && resource.exists()) {
                return resource.getInputStream();
            }
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error getting content for entity %s", property), (Throwable)e);
            throw new StoreAccessException(String.format("Getting content for entity %s", property), (Throwable)e);
        }
        return null;
    }

    @Transactional
    public S unsetContent(S entity) {
        if (entity == null) {
            return entity;
        }
        Resource resource = this.getResource(entity);
        if (resource != null && resource.exists() && resource instanceof DeletableResource) {
            try {
                ((DeletableResource)resource).delete();
            }
            catch (IOException e) {
                logger.warn((Object)String.format("Unable to get file for resource %s", resource));
            }
        }
        this.unassociate(entity);
        BeanUtils.setFieldWithAnnotation(entity, ContentLength.class, (Object)0);
        return entity;
    }

    @Transactional
    public S unsetContent(S property, PropertyPath propertyPath) {
        if (property == null) {
            return property;
        }
        Resource resource = this.getResource(property, propertyPath);
        if (resource != null && resource.exists() && resource instanceof DeletableResource) {
            try {
                ((DeletableResource)resource).delete();
            }
            catch (IOException e) {
                logger.warn((Object)String.format("Unable to get file for resource %s", resource));
            }
        }
        this.unassociate(property, propertyPath);
        ContentProperty contentProperty = this.mappingContext.getContentProperty(property.getClass(), propertyPath.getName());
        contentProperty.setContentLength(property, (Object)0);
        return property;
    }

    private Object convertToExternalContentIdType(S property, Object contentId) {
        if (this.placer.canConvert(TypeDescriptor.forObject((Object)contentId), TypeDescriptor.valueOf((Class)BeanUtils.getFieldWithAnnotationType(property, ContentId.class)))) {
            contentId = this.placer.convert(contentId, TypeDescriptor.forObject((Object)contentId), TypeDescriptor.valueOf((Class)BeanUtils.getFieldWithAnnotationType(property, ContentId.class)));
            return contentId;
        }
        return contentId.toString();
    }

    private void setContentId(S entity, PropertyPath propertyPath, SID contentId, Condition condition) {
        Assert.notNull(entity, (String)"entity must not be null");
        Assert.notNull((Object)propertyPath, (String)"propertyPath must not be null");
        BeanWrapperImpl wrapper = new BeanWrapperImpl(entity);
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (property == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        wrapper.setPropertyValue(property.getContentIdPropertyPath(), contentId);
    }
}

