/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.jpa.operations;

import internal.org.springframework.content.jpa.utils.InputStreamEx;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.annotations.ContentLength;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;

public class JpaContentTemplate
implements InitializingBean {
    private static Log logger = LogFactory.getLog(JpaContentTemplate.class);
    private DataSource datasource;
    private JdbcTemplate template;

    @Autowired
    public JpaContentTemplate(DataSource datasource) {
        this.datasource = datasource;
    }

    @Autowired(required=false)
    public void setTemplate(JdbcTemplate template) {
        this.template = template;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.template == null) {
            this.template = new JdbcTemplate(this.datasource);
        }
        this.template.execute((ConnectionCallback)new ConnectionCallback<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer doInConnection(Connection con) throws SQLException, DataAccessException {
                ResultSet rs = null;
                Statement stmt = null;
                try {
                    rs = con.getMetaData().getTables(null, null, "BLOBS", new String[]{"TABLE"});
                    if (!rs.next()) {
                        logger.info((Object)"Creating JPA Content Repository");
                        stmt = JpaContentTemplate.this.datasource.getConnection().createStatement();
                        String sql = "CREATE TABLE BLOBS (id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 1),  blob BLOB,  PRIMARY KEY ( id ))";
                        Integer n = stmt.executeUpdate(sql);
                        return n;
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                return null;
            }
        });
    }

    public <T> void setContent(final T metadata, final InputStream content) {
        if (BeanUtils.getFieldWithAnnotation(metadata, ContentId.class) == null) {
            final String sql = "INSERT INTO BLOBS VALUES(NULL, ?);";
            this.template.execute(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                    return con.prepareStatement(sql, 1);
                }
            }, (PreparedStatementCallback)new PreparedStatementCallback<Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public Integer doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                    ResultSet set = null;
                    int id = 0;
                    int rc = 0;
                    InputStreamEx in = new InputStreamEx(content);
                    ps.setBinaryStream(1, in);
                    rc = ps.executeUpdate();
                    set = ps.getGeneratedKeys();
                    set.next();
                    id = set.getInt("ID");
                    BeanUtils.setFieldWithAnnotation((Object)metadata, ContentId.class, (Object)id);
                    BeanUtils.setFieldWithAnnotation((Object)metadata, ContentLength.class, (Object)in.getLength());
                    Integer n = rc;
                    if (set == null) return n;
                    try {
                        set.close();
                        return n;
                    }
                    catch (SQLException e) {
                        logger.error((Object)String.format("Unexpected error closing result set for content id %s", id));
                    }
                    return n;
                    catch (SQLException sqle) {
                        try {
                            logger.error((Object)"Error inserting content", (Throwable)sqle);
                            if (set == null) return rc;
                        }
                        catch (Throwable throwable) {
                            if (set == null) throw throwable;
                            try {
                                set.close();
                                throw throwable;
                            }
                            catch (SQLException e) {
                                logger.error((Object)String.format("Unexpected error closing result set for content id %s", id));
                            }
                            throw throwable;
                        }
                        try {
                            set.close();
                            return rc;
                        }
                        catch (SQLException e) {
                            logger.error((Object)String.format("Unexpected error closing result set for content id %s", id));
                        }
                        return rc;
                    }
                }
            });
        } else {
            String sql = "UPDATE BLOBS SET blob=? WHERE id=" + BeanUtils.getFieldWithAnnotation(metadata, ContentId.class);
            this.template.execute(sql, (PreparedStatementCallback)new PreparedStatementCallback<Object>(){

                public Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                    int rc = 0;
                    try {
                        InputStreamEx in = new InputStreamEx(content);
                        ps.setBinaryStream(1, in);
                        rc = ps.executeUpdate();
                        BeanUtils.setFieldWithAnnotation((Object)metadata, ContentLength.class, (Object)in.getLength());
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)String.format("Error updating content %s", BeanUtils.getFieldWithAnnotation((Object)metadata, ContentId.class)), (Throwable)sqle);
                    }
                    return rc;
                }
            });
        }
    }

    public <T> void unsetContent(final T metadata) {
        String sql = "DELETE FROM BLOBS WHERE id=" + BeanUtils.getFieldWithAnnotation(metadata, ContentId.class);
        this.template.execute(sql, (PreparedStatementCallback)new PreparedStatementCallback<Integer>(){

            public Integer doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                int rc = 0;
                try {
                    rc = ps.executeUpdate();
                    BeanUtils.setFieldWithAnnotation((Object)metadata, ContentId.class, null);
                    BeanUtils.setFieldWithAnnotation((Object)metadata, ContentLength.class, (Object)0);
                }
                catch (SQLException sqle) {
                    logger.error((Object)String.format("Error deleting content %s", BeanUtils.getFieldWithAnnotation((Object)metadata, ContentId.class)), (Throwable)sqle);
                }
                return rc;
            }
        });
    }

    public <T> InputStream getContent(final T metadata) {
        String sql = "SELECT blob FROM BLOBS WHERE id='" + BeanUtils.getFieldWithAnnotation(metadata, ContentId.class) + "'";
        return (InputStream)this.template.execute(sql, (PreparedStatementCallback)new PreparedStatementCallback<InputStream>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public InputStream doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                ResultSet set;
                block18: {
                    set = null;
                    set = ps.executeQuery();
                    if (set.next()) break block18;
                    InputStream inputStream = null;
                    if (set == null) return inputStream;
                    try {
                        set.close();
                        return inputStream;
                    }
                    catch (SQLException sqle) {
                        logger.error((Object)String.format("Error closing resultset for content %s", BeanUtils.getFieldWithAnnotation((Object)metadata, ContentId.class)), (Throwable)sqle);
                    }
                    return inputStream;
                }
                Blob b = set.getBlob("blob");
                byte[] bytes = IOUtils.toByteArray((InputStream)b.getBinaryStream());
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                if (set == null) return byteArrayInputStream;
                try {
                    set.close();
                    return byteArrayInputStream;
                }
                catch (SQLException sqle) {
                    logger.error((Object)String.format("Error closing resultset for content %s", BeanUtils.getFieldWithAnnotation((Object)metadata, ContentId.class)), (Throwable)sqle);
                }
                return byteArrayInputStream;
                {
                    catch (IOException ioe) {
                        InputStream inputStream = null;
                        if (set == null) return inputStream;
                        try {
                            set.close();
                            return inputStream;
                        }
                        catch (SQLException sqle) {
                            logger.error((Object)String.format("Error closing resultset for content %s", BeanUtils.getFieldWithAnnotation((Object)metadata, ContentId.class)), (Throwable)sqle);
                        }
                        return inputStream;
                        catch (SQLException sqle) {
                            try {
                                logger.error((Object)String.format("Error getting content %s", BeanUtils.getFieldWithAnnotation((Object)metadata, ContentId.class)), (Throwable)sqle);
                                if (set == null) return null;
                            }
                            catch (Throwable throwable) {
                                if (set == null) throw throwable;
                                try {
                                    set.close();
                                    throw throwable;
                                }
                                catch (SQLException sqle2) {
                                    logger.error((Object)String.format("Error closing resultset for content %s", BeanUtils.getFieldWithAnnotation((Object)metadata, ContentId.class)), (Throwable)sqle2);
                                }
                                throw throwable;
                            }
                            try {
                                set.close();
                                return null;
                            }
                            catch (SQLException sqle3) {
                                logger.error((Object)String.format("Error closing resultset for content %s", BeanUtils.getFieldWithAnnotation((Object)metadata, ContentId.class)), (Throwable)sqle3);
                            }
                            return null;
                        }
                    }
                }
            }
        });
    }
}

