/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.jpa.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.annotations.ContentLength;
import org.springframework.content.commons.io.DeletableResource;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.repository.StoreAccessException;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.commons.utils.Condition;
import org.springframework.content.jpa.io.BlobResource;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.WritableResource;

public class DefaultJpaStoreImpl<S, SID extends Serializable>
implements Store<SID>,
AssociativeStore<S, SID>,
ContentStore<S, SID> {
    private static Log logger = LogFactory.getLog(DefaultJpaStoreImpl.class);
    private ResourceLoader loader;

    public DefaultJpaStoreImpl(ResourceLoader blobResourceLoader) {
        this.loader = blobResourceLoader;
    }

    public Resource getResource(SID id) {
        return this.loader.getResource(id.toString());
    }

    public Resource getResource(S entity) {
        Object contentId = BeanUtils.getFieldWithAnnotation(entity, ContentId.class);
        if (contentId == null) {
            return null;
        }
        return this.loader.getResource(contentId.toString());
    }

    public void associate(S entity, SID id) {
        BeanUtils.setFieldWithAnnotation(entity, ContentId.class, (Object)id.toString());
    }

    public void unassociate(S entity) {
        BeanUtils.setFieldWithAnnotationConditionally(entity, ContentId.class, null, (Condition)new Condition(){

            public boolean matches(Field field) {
                for (Annotation annotation : field.getAnnotations()) {
                    if (!"javax.persistence.Id".equals(annotation.annotationType().getCanonicalName()) && !"org.springframework.data.annotation.Id".equals(annotation.annotationType().getCanonicalName())) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public InputStream getContent(S entity) {
        Object id = BeanUtils.getFieldWithAnnotation(entity, ContentId.class);
        if (id == null) {
            return null;
        }
        Resource resource = this.loader.getResource(id.toString());
        try {
            return resource.getInputStream();
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error getting content for entity %s", entity), (Throwable)e);
            throw new StoreAccessException(String.format("Getting content for entity %s", entity), (Throwable)e);
        }
    }

    public S setContent(S entity, InputStream content) {
        Resource resource = this.getResource(entity);
        if (resource == null) {
            UUID contentId = UUID.randomUUID();
            Object convertedId = this.convertToExternalContentIdType(entity, contentId);
            resource = this.getResource((S)((Serializable)convertedId));
            BeanUtils.setFieldWithAnnotation(entity, ContentId.class, (Object)convertedId);
        }
        OutputStream os = null;
        long contentLen = -1L;
        try {
            if (resource instanceof WritableResource) {
                os = ((WritableResource)resource).getOutputStream();
                contentLen = IOUtils.copyLarge((InputStream)content, (OutputStream)os);
            }
        }
        catch (IOException e) {
            try {
                logger.error((Object)String.format("Unexpected error setting content for entity %s", entity), (Throwable)e);
                throw new StoreAccessException(String.format("Setting content for entity %s", entity), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)content);
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)content);
        IOUtils.closeQuietly((OutputStream)os);
        this.waitForCommit((BlobResource)resource);
        BeanUtils.setFieldWithAnnotation(entity, ContentId.class, (Object)((BlobResource)resource).getId());
        BeanUtils.setFieldWithAnnotation(entity, ContentLength.class, (Object)contentLen);
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCommit(BlobResource resource) {
        BlobResource blobResource = resource;
        synchronized (blobResource) {
            return;
        }
    }

    public S unsetContent(S metadata) {
        Resource resource;
        Object id = BeanUtils.getFieldWithAnnotation(metadata, ContentId.class);
        if (id == null) {
            id = -1L;
        }
        if ((resource = this.loader.getResource(id.toString())) instanceof DeletableResource) {
            try {
                ((DeletableResource)resource).delete();
            }
            catch (Exception e) {
                logger.error((Object)String.format("Unexpected error unsetting content for entity %s", metadata));
                throw new StoreAccessException(String.format("Unsetting content for entity %s", metadata), (Throwable)e);
            }
        }
        this.unassociate(metadata);
        BeanUtils.setFieldWithAnnotation(metadata, ContentLength.class, (Object)0);
        return metadata;
    }

    protected Object convertToExternalContentIdType(S property, Object contentId) {
        DefaultConversionService converter = new DefaultConversionService();
        if (converter.canConvert(TypeDescriptor.forObject((Object)contentId), TypeDescriptor.valueOf((Class)BeanUtils.getFieldWithAnnotationType(property, ContentId.class)))) {
            contentId = converter.convert(contentId, TypeDescriptor.forObject((Object)contentId), TypeDescriptor.valueOf((Class)BeanUtils.getFieldWithAnnotationType(property, ContentId.class)));
            return contentId;
        }
        return contentId.toString();
    }
}

