/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.jpa.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.net.URL;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.CountDownLatch;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.content.jpa.io.BlobResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class AbstractBlobResource
implements BlobResource {
    private static Log logger = LogFactory.getLog(AbstractBlobResource.class);
    private Object id;
    private JdbcTemplate template;
    private PlatformTransactionManager txnMgr;

    public AbstractBlobResource(Object id, JdbcTemplate template, PlatformTransactionManager txnMgr) {
        this.id = id;
        this.template = template;
        this.txnMgr = txnMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getId() {
        Object object = this.id;
        synchronized (object) {
            return this.id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setId(Object id) {
        Object object = id;
        synchronized (object) {
            this.id = id;
        }
    }

    protected JdbcTemplate getTemplate() {
        return this.template;
    }

    public boolean isWritable() {
        return true;
    }

    public OutputStream getOutputStream() throws IOException {
        Object id = this.id;
        final AbstractBlobResource resource = this;
        TransactionTemplate txn = new TransactionTemplate(this.txnMgr);
        PipedInputStream is = new PipedInputStream();
        PipedOutputStream synchronizedOutputStream = new PipedOutputStream(is){

            @Override
            public void write(int b) throws IOException {
                super.write(b);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                super.close();
                AbstractBlobResource abstractBlobResource = resource;
                synchronized (abstractBlobResource) {
                    return;
                }
            }
        };
        CountDownLatch latch = new CountDownLatch(1);
        Thread t = new Thread(() -> {
            AbstractBlobResource abstractBlobResource = resource;
            synchronized (abstractBlobResource) {
                latch.countDown();
                try {
                    Object rc = this.update(txn, is, id, resource);
                    if (rc != null && !rc.equals(-1)) {
                        resource.setId(rc);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)String.format("updating resource %s", resource.getFilename()), (Throwable)e);
                }
            }
        });
        t.start();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            logger.warn((Object)String.format("waiting for countdown latch for resource %s", resource.getFilename()), (Throwable)e);
        }
        return synchronizedOutputStream;
    }

    private Object update(TransactionTemplate txn, final InputStream fin, final Object id, final AbstractBlobResource resource) throws SQLException {
        final Object rid = this.id;
        return txn.execute((TransactionCallback)new TransactionCallback<String>(){

            public String doInTransaction(TransactionStatus transactionStatus) {
                String rc = null;
                if (AbstractBlobResource.this.exists()) {
                    String sql = "UPDATE BLOBS SET content=? WHERE id=?";
                    rc = (String)AbstractBlobResource.this.template.execute(sql, (PreparedStatementCallback)new PreparedStatementCallback<String>(){

                        public String doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                            resource.setId(-1);
                            ps.setBlob(1, fin);
                            ps.setString(2, id.toString());
                            ps.executeUpdate();
                            IOUtils.closeQuietly((InputStream)fin);
                            return id.toString();
                        }
                    });
                } else {
                    final String sql = "INSERT INTO BLOBS (id,content) VALUES(?,?)";
                    rc = (String)AbstractBlobResource.this.template.execute(new PreparedStatementCreator(){

                        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                            return con.prepareStatement(sql, 1);
                        }
                    }, (PreparedStatementCallback)new PreparedStatementCallback<String>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public String doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                            ResultSet set = null;
                            try {
                                ps.setString(1, rid.toString());
                                ps.setBlob(2, fin);
                                ps.executeUpdate();
                                IOUtils.closeQuietly((InputStream)fin);
                                String string = rid.toString();
                                return string;
                            }
                            catch (SQLException sqle) {
                                logger.error((Object)"inserting content", (Throwable)sqle);
                            }
                            finally {
                                if (set != null) {
                                    try {
                                        set.close();
                                    }
                                    catch (SQLException e) {
                                        logger.error((Object)"closing insert content set", (Throwable)e);
                                    }
                                }
                            }
                            return null;
                        }
                    });
                }
                return rc;
            }
        });
    }

    public boolean exists() {
        String sql = "SELECT COUNT(id) FROM BLOBS WHERE id='" + this.id + "'";
        return (Boolean)this.template.query(sql, (ResultSetExtractor)new ResultSetExtractor<Boolean>(){

            public Boolean extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (rs.next()) {
                    int count = rs.getInt(1);
                    return count == 1;
                }
                return false;
            }
        });
    }

    public boolean isReadable() {
        return false;
    }

    public boolean isOpen() {
        return false;
    }

    public URL getURL() throws IOException {
        return null;
    }

    public URI getURI() throws IOException {
        return null;
    }

    public File getFile() throws IOException {
        return null;
    }

    public long contentLength() throws IOException {
        return 0L;
    }

    public long lastModified() throws IOException {
        return 0L;
    }

    public Resource createRelative(String relativePath) throws IOException {
        return null;
    }

    public String getFilename() {
        return this.id.toString();
    }

    public String getDescription() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        Object id = this.id;
        String sql = this.getSelectBlobSQL(this.id);
        DataSource ds = this.template.getDataSource();
        Connection conn = DataSourceUtils.getConnection((DataSource)ds);
        try {
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            logger.error((Object)String.format("getting content %s", id), (Throwable)e);
        }
        InputStream is = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                try {
                    rs.close();
                    stmt.close();
                    DataSourceUtils.releaseConnection((Connection)conn, (DataSource)ds);
                }
                catch (SQLException sqle) {
                    logger.debug((Object)String.format("failed to release database connection while fetching content %s", id), (Throwable)sqle);
                }
                finally {
                    return null;
                }
            }
            Blob b = rs.getBlob(2);
            is = b.getBinaryStream();
        }
        catch (SQLException e) {
            logger.error((Object)String.format("getting content %s", id), (Throwable)e);
        }
        return new ClosingInputStream(id, is, rs, stmt, conn, ds);
    }

    public void delete() throws IOException {
        Object id = this.id;
        String sql = "DELETE FROM BLOBS WHERE id='" + this.id + "'";
        this.template.update(sql);
    }

    protected String getSelectBlobSQL(Object id) {
        return "SELECT id, content FROM BLOBS WHERE id='" + id + "'";
    }

    public class ClosingInputStream
    extends InputStream {
        private Object id;
        private InputStream actual;
        private ResultSet rs;
        private Statement stmt;
        private Connection conn;
        private DataSource ds;

        public ClosingInputStream(Object id, InputStream actual, ResultSet rs, Statement stmt, Connection conn, DataSource ds) {
            this.id = id;
            this.actual = actual;
            this.rs = rs;
            this.stmt = stmt;
            this.conn = conn;
            this.ds = ds;
        }

        @Override
        public int read() throws IOException {
            return this.actual.read();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                try {
                    try {
                        try {
                            this.actual.close();
                        }
                        catch (IOException e) {
                            logger.debug((Object)String.format("closing content stream %s", this.id), (Throwable)e);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            this.rs.close();
                        }
                        catch (SQLException e) {
                            logger.debug((Object)String.format("closing content resultset %s", this.id), (Throwable)e);
                        }
                        throw throwable;
                    }
                    try {
                        this.rs.close();
                    }
                    catch (SQLException e) {
                        logger.debug((Object)String.format("closing content resultset %s", this.id), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.stmt.close();
                    }
                    catch (SQLException e) {
                        logger.debug((Object)String.format("closing content statement %s", this.id), (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    this.stmt.close();
                }
                catch (SQLException e) {
                    logger.debug((Object)String.format("closing content statement %s", this.id), (Throwable)e);
                }
            }
            finally {
                DataSourceUtils.releaseConnection((Connection)this.conn, (DataSource)this.ds);
            }
        }
    }
}

