/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.jpa.io;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.content.jpa.io.BlobResource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class BlobResourceOutputStream
extends OutputStream {
    private static Log logger = LogFactory.getLog(BlobResourceOutputStream.class);
    private BlobResource blobResource;
    private JdbcTemplate template;
    private Connection con;
    private PreparedStatement ps;
    private ResultSet rs;
    private OutputStream os;
    private Blob blob;
    private boolean insert;

    public BlobResourceOutputStream(BlobResource blobResource, JdbcTemplate template) {
        this.blobResource = blobResource;
        this.template = template;
    }

    protected BlobResource getResource() {
        return this.blobResource;
    }

    protected JdbcTemplate getTemplate() {
        return this.template;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.os == null) {
            this.os = this.initializeStream();
        }
        this.os.write(b);
    }

    protected OutputStream initializeStream() {
        Object rid = this.blobResource.getId();
        this.con = DataSourceUtils.getConnection((DataSource)this.template.getDataSource());
        String sql = "SELECT id, content FROM BLOBS WHERE id=?";
        try {
            this.ps = this.con.prepareStatement(sql, 1005, 1008);
            this.ps.setString(1, rid.toString());
            this.rs = this.ps.executeQuery();
            if (!this.rs.next()) {
                this.insert = true;
                this.rs.moveToInsertRow();
            }
            this.blob = this.ps.getConnection().createBlob();
            return this.blob.setBinaryStream(1L);
        }
        catch (SQLException e) {
            logger.error((Object)String.format("intializing stream for blob resource %s", rid), (Throwable)e);
            return null;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void close() throws IOException {
        block12: {
            block11: {
                IOUtils.closeQuietly((OutputStream)this.os);
                this.rs.updateString(1, this.blobResource.getId().toString());
                this.rs.updateBlob(2, this.blob);
                if (!this.insert) {
                    this.rs.updateRow();
                    break block11;
                }
                this.rs.insertRow();
            }
            try {
                this.rs.close();
                this.ps.close();
                DataSourceUtils.releaseConnection((Connection)this.con, (DataSource)this.template.getDataSource());
            }
            catch (SQLException e) {
                logger.error((Object)String.format("closing resources for blob resource %s", this.blobResource.getId()), (Throwable)e);
            }
            break block12;
            catch (SQLException e) {
                try {
                    logger.error((Object)String.format("closing stream for blob resource %s", this.blobResource.getId()), (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        this.rs.close();
                        this.ps.close();
                        DataSourceUtils.releaseConnection((Connection)this.con, (DataSource)this.template.getDataSource());
                    }
                    catch (SQLException e2) {
                        logger.error((Object)String.format("closing resources for blob resource %s", this.blobResource.getId()), (Throwable)e2);
                    }
                    throw throwable;
                }
                try {
                    this.rs.close();
                    this.ps.close();
                    DataSourceUtils.releaseConnection((Connection)this.con, (DataSource)this.template.getDataSource());
                }
                catch (SQLException e3) {
                    logger.error((Object)String.format("closing resources for blob resource %s", this.blobResource.getId()), (Throwable)e3);
                }
            }
        }
        super.close();
    }

    public Blob getBlob() {
        String sql = "SELECT id, content FROM BLOBS WHERE id='" + this.blobResource.getId() + "'";
        return (Blob)this.template.query(sql, (ResultSetExtractor)new ResultSetExtractor<Blob>(){

            public Blob extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (rs.next()) {
                    return rs.getBlob(1);
                }
                return null;
            }
        });
    }
}

