/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.jpa.io;

import internal.org.springframework.content.jpa.io.PostgresBlobResourceOutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.springframework.content.jpa.io.AbstractBlobResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.PlatformTransactionManager;

public class PostgresBlobResource
extends AbstractBlobResource {
    private static Log logger = LogFactory.getLog(PostgresBlobResource.class);

    public PostgresBlobResource(Object id, JdbcTemplate template, PlatformTransactionManager txnMgr) {
        super(id, template, txnMgr);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        Object id = this.getId();
        String sql = this.getSelectBlobSQL(id);
        DataSource ds = this.getTemplate().getDataSource();
        Connection conn = DataSourceUtils.getConnection((DataSource)ds);
        InputStream is = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                try {
                    rs.close();
                    stmt.close();
                    DataSourceUtils.releaseConnection((Connection)conn, (DataSource)ds);
                    return null;
                }
                catch (SQLException sqle) {
                    logger.debug((Object)String.format("failed to release database connection while fetching content %s", id), (Throwable)sqle);
                }
            }
            LargeObjectManager lobj = conn.unwrap(PGConnection.class).getLargeObjectAPI();
            long oid = rs.getLong(2);
            LargeObject obj = lobj.open(oid, 262144);
            is = obj.getInputStream(-1L);
        }
        catch (SQLException e) {
            logger.error((Object)String.format("getting content %s", id), (Throwable)e);
            return null;
        }
        return new AbstractBlobResource.ClosingInputStream(id, is, rs, stmt, conn, ds);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new BufferedOutputStream(new PostgresBlobResourceOutputStream(this, this.getTemplate()), 10);
    }
}

