/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.jpa.io;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.jpa.io.BlobResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.util.ClassUtils;

public class DelegatingBlobResourceLoader
implements ResourceLoader {
    private static Log logger = LogFactory.getLog(DelegatingBlobResourceLoader.class);
    private DataSource ds;
    private Map<String, BlobResourceLoader> loaders;
    private String database = null;

    @Autowired
    public DelegatingBlobResourceLoader(DataSource ds, List<BlobResourceLoader> loaders) {
        this.ds = ds;
        this.loaders = new HashMap<String, BlobResourceLoader>();
        for (BlobResourceLoader loader : loaders) {
            String database = loader.getDatabaseName();
            if (database == null) continue;
            this.loaders.put(database, loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getResource(String location) {
        BlobResourceLoader loader;
        if (this.database == null) {
            Connection conn = DataSourceUtils.getConnection((DataSource)this.ds);
            try {
                this.database = conn.getMetaData().getDatabaseProductName();
            }
            catch (SQLException e) {
                logger.error((Object)"Error fetching database name", (Throwable)e);
            }
            finally {
                DataSourceUtils.releaseConnection((Connection)conn, (DataSource)this.ds);
            }
        }
        if ((loader = this.loaders.get(this.database)) == null) {
            loader = this.loaders.get("GENERIC");
        }
        return loader.getResource(location);
    }

    public ClassLoader getClassLoader() {
        return ClassUtils.getDefaultClassLoader();
    }
}

