/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.jpa.io;

import internal.org.springframework.content.jpa.io.PostgresBlobResourceOutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.springframework.content.jpa.io.AbstractBlobResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class PostgresBlobResource
extends AbstractBlobResource {
    private static Log logger = LogFactory.getLog(PostgresBlobResource.class);

    public PostgresBlobResource(Object id, JdbcTemplate template, PlatformTransactionManager txnMgr) {
        super(id, template, txnMgr);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        Object id = this.getId();
        String sql = this.getSelectBlobSQL(id);
        TransactionStatus status = null;
        if (this.getTransactionManager() != null) {
            status = this.getTransactionManager().getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        }
        DataSource ds = this.getTemplate().getDataSource();
        Connection conn = DataSourceUtils.getConnection((DataSource)ds);
        InputStream is = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                try {
                    rs.close();
                    stmt.close();
                    DataSourceUtils.releaseConnection((Connection)conn, (DataSource)ds);
                    return null;
                }
                catch (SQLException sqle) {
                    logger.debug((Object)String.format("failed to release database connection while fetching content %s", id), (Throwable)sqle);
                }
            }
            LargeObjectManager lobj = conn.unwrap(PGConnection.class).getLargeObjectAPI();
            long oid = rs.getLong(2);
            LargeObject obj = lobj.open(oid, 262144);
            is = obj.getInputStream(-1L);
        }
        catch (SQLException e) {
            logger.error((Object)String.format("getting content %s", id), (Throwable)e);
            return null;
        }
        return new AbstractBlobResource.ClosingInputStream(id, is, rs, stmt, status, this.getTransactionManager(), conn, ds);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new BufferedOutputStream(new PostgresBlobResourceOutputStream(this, this.getTemplate()), 10);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void delete() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

