/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.jpa.io;

import internal.org.springframework.content.jpa.io.BlobResourceOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.springframework.content.jpa.io.BlobResource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class PostgresBlobResourceOutputStream
extends BlobResourceOutputStream {
    private static Log logger = LogFactory.getLog(PostgresBlobResourceOutputStream.class);
    private Connection con;
    private PreparedStatement ps;
    private ResultSet rs;
    private OutputStream os;
    private LargeObject lo;
    private boolean insert;

    public PostgresBlobResourceOutputStream(BlobResource blobResource, JdbcTemplate template) {
        super(blobResource, template);
    }

    @Override
    protected OutputStream initializeStream() {
        Object rid = this.getResource().getId();
        this.con = DataSourceUtils.getConnection((DataSource)this.getTemplate().getDataSource());
        String sql = "SELECT id, content FROM BLOBS WHERE id=?";
        try {
            this.ps = this.con.prepareStatement(sql, 1005, 1008);
            this.ps.setString(1, rid.toString());
            this.rs = this.ps.executeQuery();
            if (!this.rs.next()) {
                this.insert = true;
                this.rs.moveToInsertRow();
            }
            LargeObjectManager lobj = this.con.unwrap(PGConnection.class).getLargeObjectAPI();
            long oid = lobj.createLO(393216);
            this.lo = lobj.open(oid);
            return this.lo.getOutputStream();
        }
        catch (SQLException e) {
            logger.error((Object)String.format("initializing postgres blob output stream for resource: %s", rid), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void close() throws IOException {
        block18: {
            Long oidToBeRemoved;
            Object rid;
            block17: {
                rid = this.getResource().getId();
                IOUtils.closeQuietly((OutputStream)this.os);
                try {
                    this.lo.close();
                }
                catch (SQLException e) {
                    logger.error((Object)String.format("closing large object for resource %s", rid));
                }
                oidToBeRemoved = null;
                this.rs.updateString(1, rid.toString());
                if (!this.insert) {
                    oidToBeRemoved = this.rs.getLong(2);
                }
                this.rs.updateLong(2, (long)this.lo.getOID());
                if (!this.insert) {
                    this.rs.updateRow();
                    break block17;
                }
                this.rs.insertRow();
            }
            try {
                this.rs.close();
                this.ps.close();
                if (oidToBeRemoved != null) {
                    this.deleteReplacedLO(this.con, oidToBeRemoved);
                }
                DataSourceUtils.releaseConnection((Connection)this.con, (DataSource)this.getTemplate().getDataSource());
            }
            catch (SQLException e) {
                logger.error((Object)String.format("finalizing large object for resource %s", rid));
            }
            break block18;
            catch (SQLException e) {
                try {
                    logger.error((Object)String.format("updating large object for resource %s", rid));
                }
                catch (Throwable throwable) {
                    try {
                        this.rs.close();
                        this.ps.close();
                        if (oidToBeRemoved != null) {
                            this.deleteReplacedLO(this.con, oidToBeRemoved);
                        }
                        DataSourceUtils.releaseConnection((Connection)this.con, (DataSource)this.getTemplate().getDataSource());
                    }
                    catch (SQLException e2) {
                        logger.error((Object)String.format("finalizing large object for resource %s", rid));
                    }
                    throw throwable;
                }
                try {
                    this.rs.close();
                    this.ps.close();
                    if (oidToBeRemoved != null) {
                        this.deleteReplacedLO(this.con, oidToBeRemoved);
                    }
                    DataSourceUtils.releaseConnection((Connection)this.con, (DataSource)this.getTemplate().getDataSource());
                }
                catch (SQLException e3) {
                    logger.error((Object)String.format("finalizing large object for resource %s", rid));
                }
            }
        }
    }

    private void deleteReplacedLO(Connection con2, Long oidToBeRemoved) {
        try {
            LargeObjectManager lobj = this.con.unwrap(PGConnection.class).getLargeObjectAPI();
            lobj.delete(oidToBeRemoved.longValue());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Blob getBlob() {
        String sql = "SELECT id, content FROM BLOBS WHERE id='" + this.getResource().getId() + "'";
        return (Blob)this.getTemplate().query(sql, (ResultSetExtractor)new ResultSetExtractor<Blob>(){

            public Blob extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (rs.next()) {
                    return rs.getBlob(1);
                }
                return null;
            }
        });
    }
}

