/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.jpa.io;

import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.content.jpa.io.AbstractBlobResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.PlatformTransactionManager;

public class SQLServerBlobResource
extends AbstractBlobResource {
    private static Log logger = LogFactory.getLog(SQLServerBlobResource.class);

    public SQLServerBlobResource(Object id, JdbcTemplate template, PlatformTransactionManager txnMgr) {
        super(id, template, txnMgr);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        Object id = this.getId();
        String sql = this.getSelectBlobSQL(this.getId());
        DataSource ds = this.getTemplate().getDataSource();
        Connection conn = DataSourceUtils.getConnection((DataSource)ds);
        try {
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            logger.error((Object)String.format("setting autocommit to false whilst getting content %s", id), (Throwable)e);
        }
        InputStream is = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement(1003, 1008);
            if (stmt.isWrapperFor(SQLServerStatement.class)) {
                SQLServerStatement SQLstmt = stmt.unwrap(SQLServerStatement.class);
                SQLstmt.setResponseBuffering("adaptive");
            }
            if (!(rs = stmt.executeQuery(sql)).next()) {
                return null;
            }
            is = rs.getBinaryStream(2);
        }
        catch (SQLException e) {
            logger.error((Object)String.format("getting content %s", id), (Throwable)e);
        }
        return new AbstractBlobResource.ClosingInputStream(id, is, rs, stmt, null, this.getTransactionManager(), conn, ds);
    }
}

