/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.jpa.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.annotations.ContentLength;
import org.springframework.content.commons.io.DeletableResource;
import org.springframework.content.commons.mappingcontext.ContentProperty;
import org.springframework.content.commons.mappingcontext.MappingContext;
import org.springframework.content.commons.property.PropertyPath;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.GetResourceParams;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.repository.StoreAccessException;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.commons.utils.Condition;
import org.springframework.content.jpa.io.BlobResource;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.WritableResource;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class DefaultJpaStoreImpl<S, SID extends Serializable>
implements Store<SID>,
AssociativeStore<S, SID>,
ContentStore<S, SID> {
    private static Log logger = LogFactory.getLog(DefaultJpaStoreImpl.class);
    private ResourceLoader loader;
    private MappingContext mappingContext;

    public DefaultJpaStoreImpl(ResourceLoader blobResourceLoader, MappingContext mappingContext) {
        this.loader = blobResourceLoader;
        this.mappingContext = mappingContext;
        if (this.mappingContext == null) {
            this.mappingContext = new MappingContext((CharSequence)"/", (CharSequence)".");
        }
    }

    public Resource getResource(SID id) {
        return this.loader.getResource(id.toString());
    }

    public Resource getResource(S entity) {
        Object contentId = BeanUtils.getFieldWithAnnotation(entity, ContentId.class);
        if (contentId == null) {
            return null;
        }
        return this.loader.getResource(contentId.toString());
    }

    public Resource getResource(S entity, PropertyPath propertyPath) {
        return this.getResource(entity, propertyPath, GetResourceParams.builder().build());
    }

    public Resource getResource(S entity, PropertyPath propertyPath, GetResourceParams params) {
        SID contentId = this.getContentId(entity, propertyPath);
        if (contentId == null) {
            return null;
        }
        return this.getResource((S)contentId);
    }

    public void associate(S entity, PropertyPath propertyPath, SID id) {
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (property == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        property.setContentId(entity, id, null);
    }

    public void unassociate(S entity, PropertyPath propertyPath) {
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (property == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        property.setContentId(entity, null, new org.springframework.content.commons.mappingcontext.Condition(){

            public boolean matches(TypeDescriptor descriptor) {
                for (Annotation annotation : descriptor.getAnnotations()) {
                    if (!"javax.persistence.Id".equals(annotation.annotationType().getCanonicalName()) && !"org.springframework.data.annotation.Id".equals(annotation.annotationType().getCanonicalName())) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public void associate(S entity, SID id) {
        BeanUtils.setFieldWithAnnotation(entity, ContentId.class, (Object)id.toString());
    }

    public void unassociate(S entity) {
        BeanUtils.setFieldWithAnnotationConditionally(entity, ContentId.class, null, (Condition)new Condition(){

            public boolean matches(Field field) {
                for (Annotation annotation : field.getAnnotations()) {
                    if (!"javax.persistence.Id".equals(annotation.annotationType().getCanonicalName()) && !"org.springframework.data.annotation.Id".equals(annotation.annotationType().getCanonicalName())) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public InputStream getContent(S entity) {
        Object id = BeanUtils.getFieldWithAnnotation(entity, ContentId.class);
        if (id == null) {
            return null;
        }
        Resource resource = this.loader.getResource(id.toString());
        try {
            return resource.getInputStream();
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error getting content for entity %s", entity), (Throwable)e);
            throw new StoreAccessException(String.format("Getting content for entity %s", entity), (Throwable)e);
        }
    }

    public InputStream getContent(S entity, PropertyPath propertyPath) {
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (property == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        Object id = property.getContentId(entity);
        if (id == null) {
            return null;
        }
        Resource resource = this.loader.getResource(id.toString());
        try {
            return resource.getInputStream();
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error getting content for entity %s", entity), (Throwable)e);
            throw new StoreAccessException(String.format("Getting content for entity %s", entity), (Throwable)e);
        }
    }

    @Transactional
    public S setContent(S entity, InputStream content) {
        Resource resource;
        Object contentId = BeanUtils.getFieldWithAnnotation(entity, ContentId.class);
        if (contentId == null) {
            String newId = UUID.randomUUID().toString();
            Object convertedId = this.convertToExternalContentIdType(entity, newId);
            BeanUtils.setFieldWithAnnotation(entity, ContentId.class, (Object)convertedId);
        }
        if ((resource = this.getResource(entity)) == null) {
            return entity;
        }
        OutputStream os = null;
        long contentLen = -1L;
        try {
            if (resource instanceof WritableResource) {
                os = ((WritableResource)resource).getOutputStream();
                contentLen = IOUtils.copyLarge((InputStream)content, (OutputStream)os);
            }
        }
        catch (IOException e) {
            try {
                logger.error((Object)String.format("Unexpected error setting content for entity %s", entity), (Throwable)e);
                throw new StoreAccessException(String.format("Setting content for entity %s", entity), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)content);
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)content);
        IOUtils.closeQuietly((OutputStream)os);
        BeanUtils.setFieldWithAnnotation(entity, ContentId.class, (Object)((BlobResource)resource).getId());
        BeanUtils.setFieldWithAnnotation(entity, ContentLength.class, (Object)contentLen);
        return entity;
    }

    @Transactional
    public S setContent(S entity, PropertyPath propertyPath, InputStream content) {
        return this.setContent(entity, propertyPath, content, -1L);
    }

    @Transactional
    public S setContent(S entity, PropertyPath propertyPath, InputStream content, long contentLen) {
        Resource resource;
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        SID contentId = this.getContentId(entity, propertyPath);
        if (contentId == null) {
            String newId = UUID.randomUUID().toString();
            Object convertedId = this.convertToExternalContentIdType(newId, property.getContentIdType(entity));
            this.setContentId(entity, propertyPath, (Serializable)convertedId, null);
        }
        if ((resource = this.getResource(entity, propertyPath)) == null) {
            return entity;
        }
        OutputStream os = null;
        long readLen = -1L;
        try {
            if (resource instanceof WritableResource) {
                os = ((WritableResource)resource).getOutputStream();
                readLen = IOUtils.copyLarge((InputStream)content, (OutputStream)os);
            }
        }
        catch (IOException e) {
            try {
                logger.error((Object)String.format("Unexpected error setting content for entity %s", entity), (Throwable)e);
                throw new StoreAccessException(String.format("Setting content for entity %s", entity), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)content);
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)content);
        IOUtils.closeQuietly((OutputStream)os);
        property.setContentId(entity, ((BlobResource)resource).getId(), null);
        long len = contentLen;
        if (len == -1L) {
            len = readLen;
        }
        property.setContentLength(entity, (Object)len);
        return entity;
    }

    @Transactional
    public S setContent(S entity, Resource resourceContent) {
        try {
            return this.setContent(entity, resourceContent.getInputStream());
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error setting content for entity %s", entity), (Throwable)e);
            throw new StoreAccessException(String.format("Setting content for entity %s", entity), (Throwable)e);
        }
    }

    @Transactional
    public S setContent(S entity, PropertyPath propertyPath, Resource resourceContent) {
        try {
            return this.setContent(entity, propertyPath, resourceContent.getInputStream());
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error setting content for entity %s", entity), (Throwable)e);
            throw new StoreAccessException(String.format("Setting content for entity %s", entity), (Throwable)e);
        }
    }

    @Transactional
    public S unsetContent(S metadata) {
        Resource resource;
        Object id = BeanUtils.getFieldWithAnnotation(metadata, ContentId.class);
        if (id == null) {
            id = -1L;
        }
        if ((resource = this.loader.getResource(id.toString())) instanceof DeletableResource) {
            try {
                ((DeletableResource)resource).delete();
            }
            catch (Exception e) {
                logger.error((Object)String.format("Unexpected error unsetting content for entity %s", metadata));
                throw new StoreAccessException(String.format("Unsetting content for entity %s", metadata), (Throwable)e);
            }
        }
        this.unassociate(metadata);
        BeanUtils.setFieldWithAnnotation(metadata, ContentLength.class, (Object)0);
        return metadata;
    }

    @Transactional
    public S unsetContent(S entity, PropertyPath propertyPath) {
        Resource resource;
        Object id;
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (property == null) {
            // empty if block
        }
        if ((id = property.getContentId(entity)) == null) {
            id = -1L;
        }
        if ((resource = this.loader.getResource(id.toString())) instanceof DeletableResource) {
            try {
                ((DeletableResource)resource).delete();
            }
            catch (Exception e) {
                logger.error((Object)String.format("Unexpected error unsetting content for entity %s", entity));
                throw new StoreAccessException(String.format("Unsetting content for entity %s", entity), (Throwable)e);
            }
        }
        this.unassociate(entity, propertyPath);
        property.setContentLength(entity, (Object)0);
        return entity;
    }

    protected Object convertToExternalContentIdType(S property, Object contentId) {
        DefaultConversionService converter = new DefaultConversionService();
        if (converter.canConvert(TypeDescriptor.forObject((Object)contentId), TypeDescriptor.valueOf((Class)BeanUtils.getFieldWithAnnotationType(property, ContentId.class)))) {
            contentId = converter.convert(contentId, TypeDescriptor.forObject((Object)contentId), TypeDescriptor.valueOf((Class)BeanUtils.getFieldWithAnnotationType(property, ContentId.class)));
            return contentId;
        }
        return contentId.toString();
    }

    private Object convertToExternalContentIdType(Object contentId, TypeDescriptor contentIdType) {
        DefaultConversionService converter = new DefaultConversionService();
        if (converter.canConvert(TypeDescriptor.forObject((Object)contentId), contentIdType)) {
            contentId = converter.convert(contentId, TypeDescriptor.forObject((Object)contentId), contentIdType);
            return contentId;
        }
        return contentId.toString();
    }

    private SID getContentId(S entity, PropertyPath propertyPath) {
        Assert.notNull(entity, (String)"entity must not be null");
        Assert.notNull((Object)propertyPath, (String)"propertyPath must not be null");
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (property == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        return (SID)((Serializable)property.getContentId(entity));
    }

    private void setContentId(S entity, PropertyPath propertyPath, SID contentId, Condition condition) {
        Assert.notNull(entity, (String)"entity must not be null");
        Assert.notNull((Object)propertyPath, (String)"propertyPath must not be null");
        BeanWrapperImpl wrapper = new BeanWrapperImpl(entity);
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (property == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        property.setContentId(entity, contentId, null);
    }
}

