/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.jpa.io;

import internal.org.springframework.content.jpa.io.BlobResourceOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.content.jpa.io.BlobResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

public abstract class AbstractBlobResource
implements BlobResource {
    private static Log logger = LogFactory.getLog(AbstractBlobResource.class);
    private Object id;
    private JdbcTemplate template;
    private PlatformTransactionManager txnMgr;

    public AbstractBlobResource(Object id, JdbcTemplate template, PlatformTransactionManager txnMgr) {
        this.id = id;
        this.template = template;
        this.txnMgr = txnMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getId() {
        Object object = this.id;
        synchronized (object) {
            return this.id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setId(Object id) {
        Object object = id;
        synchronized (object) {
            this.id = id;
        }
    }

    protected JdbcTemplate getTemplate() {
        return this.template;
    }

    protected PlatformTransactionManager getTransactionManager() {
        return this.txnMgr;
    }

    public boolean isWritable() {
        return true;
    }

    public OutputStream getOutputStream() throws IOException {
        return new BufferedOutputStream(new BlobResourceOutputStream(this, this.template), 10);
    }

    public boolean exists() {
        final Object id = this.id;
        String sql = "SELECT COUNT(id) FROM BLOBS WHERE id='" + this.id + "'";
        return (Boolean)this.template.query(sql, (ResultSetExtractor)new ResultSetExtractor<Boolean>(){

            public Boolean extractData(ResultSet rs) {
                try {
                    if (rs.next()) {
                        int count = rs.getInt(1);
                        return count == 1;
                    }
                }
                catch (SQLException sqle) {
                    logger.warn((Object)String.format("checking existence of blob resource %s", id), (Throwable)sqle);
                }
                return false;
            }
        });
    }

    public boolean isReadable() {
        return false;
    }

    public boolean isOpen() {
        return false;
    }

    public URL getURL() throws IOException {
        return null;
    }

    public URI getURI() throws IOException {
        return null;
    }

    public File getFile() throws IOException {
        return null;
    }

    public long contentLength() throws IOException {
        return 0L;
    }

    public long lastModified() throws IOException {
        return 0L;
    }

    public Resource createRelative(String relativePath) throws IOException {
        return null;
    }

    public String getFilename() {
        return this.id.toString();
    }

    public String getDescription() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        Object id = this.id;
        String sql = this.getSelectBlobSQL(this.id);
        DataSource ds = this.template.getDataSource();
        Connection conn = DataSourceUtils.getConnection((DataSource)ds);
        InputStream is = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                try {
                    rs.close();
                    stmt.close();
                    DataSourceUtils.releaseConnection((Connection)conn, (DataSource)ds);
                    return null;
                }
                catch (SQLException sqle) {
                    logger.debug((Object)String.format("failed to release database connection getting input stream for blob resource %s", id), (Throwable)sqle);
                }
            }
            Blob b = rs.getBlob(2);
            is = b.getBinaryStream();
        }
        catch (SQLException e) {
            logger.error((Object)String.format("getting input stream for blob resource %s", id), (Throwable)e);
            return null;
        }
        return new ClosingInputStream(id, is, rs, stmt, null, this.getTransactionManager(), conn, ds);
    }

    public void delete() throws IOException {
        String sql = "DELETE FROM BLOBS WHERE id='" + this.id + "'";
        this.template.update(sql);
    }

    protected String getSelectBlobSQL(Object id) {
        return "SELECT id, content FROM BLOBS WHERE id='" + id + "'";
    }

    public class ClosingInputStream
    extends InputStream {
        private Object id;
        private InputStream actual;
        private ResultSet rs;
        private Statement stmt;
        private TransactionStatus txnStatus;
        private PlatformTransactionManager txnMgr;
        private Connection conn;
        private DataSource ds;

        public ClosingInputStream(Object id, InputStream actual, ResultSet rs, Statement stmt, TransactionStatus txnStatus, PlatformTransactionManager txnMgr, Connection conn, DataSource ds) {
            this.id = id;
            this.actual = actual;
            this.rs = rs;
            this.stmt = stmt;
            this.txnStatus = txnStatus;
            this.txnMgr = txnMgr;
            this.conn = conn;
            this.ds = ds;
        }

        @Override
        public int read() throws IOException {
            try {
                return this.actual.read();
            }
            catch (IOException ioe) {
                if (this.txnStatus != null && !this.txnStatus.isCompleted()) {
                    this.txnMgr.rollback(this.txnStatus);
                }
                throw ioe;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                try {
                    try {
                        try {
                            try {
                                this.actual.close();
                            }
                            catch (IOException e) {
                                logger.debug((Object)String.format("closing stream for blob resource %s", this.id), (Throwable)e);
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                this.rs.close();
                            }
                            catch (SQLException e) {
                                logger.debug((Object)String.format("closing resultset for blob resource %s", this.id), (Throwable)e);
                            }
                            throw throwable;
                        }
                        try {
                            this.rs.close();
                        }
                        catch (SQLException e) {
                            logger.debug((Object)String.format("closing resultset for blob resource %s", this.id), (Throwable)e);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            this.stmt.close();
                        }
                        catch (SQLException e) {
                            logger.debug((Object)String.format("closing statement for blob resource %s", this.id), (Throwable)e);
                        }
                        throw throwable;
                    }
                    try {
                        this.stmt.close();
                    }
                    catch (SQLException e) {
                        logger.debug((Object)String.format("closing statement for blob resource %s", this.id), (Throwable)e);
                    }
                }
                finally {
                    if (this.txnStatus != null && !this.txnStatus.isCompleted()) {
                        this.txnMgr.commit(this.txnStatus);
                    }
                }
            }
            finally {
                DataSourceUtils.releaseConnection((Connection)this.conn, (DataSource)this.ds);
            }
        }
    }
}

