/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.mongo.repository;

import internal.org.springframework.content.mongo.io.GridFsStoreResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.annotations.ContentLength;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.repository.StoreAccessException;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.commons.utils.Condition;
import org.springframework.content.commons.utils.PlacementService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.io.Resource;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsCriteria;
import org.springframework.data.mongodb.gridfs.GridFsResource;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.util.Assert;

public class DefaultMongoStoreImpl<S, SID extends Serializable>
implements Store<SID>,
AssociativeStore<S, SID>,
ContentStore<S, SID> {
    private static Log logger = LogFactory.getLog(DefaultMongoStoreImpl.class);
    private GridFsTemplate gridFs;
    private PlacementService placer;

    public DefaultMongoStoreImpl(GridFsTemplate gridFs, PlacementService placer) {
        Assert.notNull((Object)gridFs, (String)"gridFs cannot be null");
        Assert.notNull((Object)placer, (String)"placer cannot be null");
        this.gridFs = gridFs;
        this.placer = placer;
    }

    public Resource getResource(SID id) {
        String location = (String)this.placer.convert(id, String.class);
        return new GridFsStoreResource(location, this.gridFs);
    }

    public Resource getResource(S entity) {
        if (entity == null) {
            return null;
        }
        Object contentId = BeanUtils.getFieldWithAnnotation(entity, ContentId.class);
        if (contentId == null) {
            return null;
        }
        String location = (String)this.placer.convert(contentId, String.class);
        return new GridFsStoreResource(location, this.gridFs);
    }

    public void associate(S entity, SID id) {
        Resource resource = this.getResource((S)id);
        Object convertedId = this.convertToExternalContentIdType(entity, id);
        BeanUtils.setFieldWithAnnotation(entity, ContentId.class, (Object)convertedId.toString());
    }

    public void unassociate(S entity) {
        BeanUtils.setFieldWithAnnotationConditionally(entity, ContentId.class, null, (Condition)new Condition(){

            public boolean matches(Field field) {
                for (Annotation annotation : field.getAnnotations()) {
                    if (!"javax.persistence.Id".equals(annotation.annotationType().getCanonicalName()) && !"org.springframework.data.annotation.Id".equals(annotation.annotationType().getCanonicalName())) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public void setContent(S property, InputStream content) {
        String location;
        GridFsResource resource;
        Object contentId = BeanUtils.getFieldWithAnnotation(property, ContentId.class);
        if (contentId == null) {
            contentId = UUID.randomUUID();
            BeanUtils.setFieldWithAnnotation(property, ContentId.class, (Object)contentId.toString());
        }
        if ((resource = this.gridFs.getResource(location = (String)this.placer.convert(contentId, String.class))) != null && resource.exists()) {
            this.gridFs.delete(Query.query((CriteriaDefinition)GridFsCriteria.whereFilename().is((Object)resource.getFilename())));
        }
        try {
            this.gridFs.store(content, location);
            resource = this.gridFs.getResource(location);
        }
        catch (Exception e) {
            logger.error((Object)String.format("Unexpected error setting content for entity  %s", property), (Throwable)e);
            throw new StoreAccessException(String.format("Setting content for entity %s", property), (Throwable)e);
        }
        long contentLen = 0L;
        try {
            contentLen = resource.contentLength();
        }
        catch (IOException ioe) {
            logger.debug((Object)String.format("Unable to retrieve content length for %s", contentId));
        }
        BeanUtils.setFieldWithAnnotation(property, ContentLength.class, (Object)contentLen);
    }

    public InputStream getContent(S entity) {
        if (entity == null) {
            return null;
        }
        Object contentId = BeanUtils.getFieldWithAnnotation(entity, ContentId.class);
        if (contentId == null) {
            return null;
        }
        String location = (String)this.placer.convert(contentId, String.class);
        GridFsResource resource = this.gridFs.getResource(location);
        try {
            if (resource != null && resource.exists()) {
                return resource.getInputStream();
            }
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error getting content for entityt %s", entity), (Throwable)e);
            throw new StoreAccessException(String.format("Getting content for entity %s", entity), (Throwable)e);
        }
        return null;
    }

    public void unsetContent(S property) {
        if (property == null) {
            return;
        }
        Object contentId = BeanUtils.getFieldWithAnnotation(property, ContentId.class);
        if (contentId == null) {
            return;
        }
        try {
            String location = (String)this.placer.convert(contentId, String.class);
            GridFsResource resource = this.gridFs.getResource(location);
            if (resource != null && resource.exists()) {
                this.gridFs.delete(Query.query((CriteriaDefinition)GridFsCriteria.whereFilename().is((Object)resource.getFilename())));
                BeanUtils.setFieldWithAnnotationConditionally(property, ContentId.class, null, (Condition)new Condition(){

                    public boolean matches(Field field) {
                        for (Annotation annotation : field.getAnnotations()) {
                            if (!"javax.persistence.Id".equals(annotation.annotationType().getCanonicalName()) && !"org.springframework.data.annotation.Id".equals(annotation.annotationType().getCanonicalName())) continue;
                            return false;
                        }
                        return true;
                    }
                });
                BeanUtils.setFieldWithAnnotation(property, ContentLength.class, (Object)0);
            }
        }
        catch (Exception ase) {
            logger.error((Object)String.format("Unexpected error unsetting content for entity %s", property), (Throwable)ase);
            throw new StoreAccessException(String.format("Unsetting content for entity %s", property), (Throwable)ase);
        }
    }

    protected Object convertToExternalContentIdType(S property, Object contentId) {
        if (this.placer.canConvert(TypeDescriptor.forObject((Object)contentId), TypeDescriptor.valueOf((Class)BeanUtils.getFieldWithAnnotationType(property, ContentId.class)))) {
            contentId = this.placer.convert(contentId, TypeDescriptor.forObject((Object)contentId), TypeDescriptor.valueOf((Class)BeanUtils.getFieldWithAnnotationType(property, ContentId.class)));
            return contentId;
        }
        return contentId.toString();
    }
}

