/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.mongo.config;

import internal.org.springframework.content.mongo.store.DefaultMongoStoreImpl;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.repository.factory.AbstractStoreFactoryBean;
import org.springframework.content.commons.utils.PlacementService;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.versions.LockingAndVersioningProxyFactory;

public class MongoStoreFactoryBean
extends AbstractStoreFactoryBean {
    @Autowired
    private GridFsTemplate gridFs;
    @Autowired
    private PlacementService mongoStorePlacementService;
    @Autowired(required=false)
    private LockingAndVersioningProxyFactory versioning;

    protected void addProxyAdvice(ProxyFactory result, BeanFactory beanFactory) {
        if (this.versioning != null) {
            this.versioning.apply(result);
        }
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
    }

    protected Object getContentStoreImpl() {
        return new DefaultMongoStoreImpl(this.gridFs, this.mongoStorePlacementService);
    }
}

