/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.mongo.io;

import com.mongodb.client.gridfs.model.GridFSFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.content.commons.io.DeletableResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsCriteria;
import org.springframework.data.mongodb.gridfs.GridFsResource;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.util.Assert;

public class GridFsStoreResource
implements Resource,
WritableResource,
DeletableResource {
    private static Log logger = LogFactory.getLog(GridFsStoreResource.class);
    private GridFsResource delegate;
    private String location;
    private GridFsTemplate gridfs;

    public GridFsStoreResource(Resource delegate, GridFsTemplate gridfs) {
        Assert.isInstanceOf(GridFsResource.class, (Object)"delegate must be an instance of GridFsResource");
        this.delegate = (GridFsResource)delegate;
        this.gridfs = gridfs;
    }

    public GridFsStoreResource(String location, GridFsTemplate gridfs) {
        Assert.notNull((Object)location, (String)"location must be specified");
        Assert.notNull((Object)location, (String)"gridfs must be specified");
        this.location = location;
        this.gridfs = gridfs;
    }

    public long contentLength() throws IOException {
        GridFSFile file = this.gridfs.findOne(Query.query((CriteriaDefinition)GridFsCriteria.whereFilename().is((Object)this.location)));
        if (file == null) {
            return 0L;
        }
        return file.getLength();
    }

    public String getFilename() throws IllegalStateException {
        return this.location;
    }

    public long lastModified() throws IOException {
        GridFSFile file = this.gridfs.findOne(Query.query((CriteriaDefinition)GridFsCriteria.whereFilename().is((Object)this.location)));
        if (file == null) {
            return -1L;
        }
        return file.getUploadDate().getTime();
    }

    public Object getId() {
        GridFSFile file = this.gridfs.findOne(Query.query((CriteriaDefinition)GridFsCriteria.whereFilename().is((Object)this.location)));
        if (file == null) {
            return null;
        }
        return file.getId();
    }

    public boolean exists() {
        return this.gridfs.findOne(Query.query((CriteriaDefinition)GridFsCriteria.whereFilename().is((Object)this.location))) != null;
    }

    public boolean isOpen() {
        return true;
    }

    public InputStream getInputStream() throws IOException, IllegalStateException {
        GridFSFile file = this.gridfs.findOne(Query.query((CriteriaDefinition)GridFsCriteria.whereFilename().is((Object)this.location)));
        if (file == null) {
            return null;
        }
        return this.gridfs.getResource(this.location).getInputStream();
    }

    public String getDescription() {
        return "GridFsStoreResource [location = '%s'" + this.location + "]";
    }

    public boolean isReadable() {
        return true;
    }

    public URL getURL() throws IOException {
        throw new UnsupportedOperationException();
    }

    public URI getURI() throws IOException {
        throw new UnsupportedOperationException();
    }

    public File getFile() throws IOException {
        throw new UnsupportedOperationException();
    }

    public Resource createRelative(String relativePath) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.format("GridFsStoreResource [location = '%s']", this.location);
    }

    public boolean isWritable() {
        return true;
    }

    public OutputStream getOutputStream() throws IOException {
        final GridFsStoreResource resource = this;
        PipedInputStream is = new PipedInputStream();
        PipedOutputStream synchronizedOutputStream = new PipedOutputStream(is){
            private boolean firstWrite;
            {
                super(x0);
                this.firstWrite = true;
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.deleteOnFirstWrite();
                super.write(b, off, len);
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.deleteOnFirstWrite();
                super.write(b);
            }

            @Override
            public void write(int b) throws IOException {
                this.deleteOnFirstWrite();
                super.write(b);
            }

            protected void deleteOnFirstWrite() {
                if (this.firstWrite) {
                    try {
                        GridFsStoreResource.this.gridfs.delete(Query.query((CriteriaDefinition)GridFsCriteria.whereFilename().is((Object)resource.getFilename())));
                    }
                    finally {
                        this.firstWrite = false;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                super.close();
                GridFsStoreResource gridFsStoreResource = resource;
                synchronized (gridFsStoreResource) {
                    return;
                }
            }
        };
        CountDownLatch latch = new CountDownLatch(1);
        Thread t = new Thread(() -> {
            GridFsStoreResource gridFsStoreResource = resource;
            synchronized (gridFsStoreResource) {
                latch.countDown();
                this.gridfs.store((InputStream)is, resource.getFilename());
            }
        });
        t.start();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            logger.warn((Object)String.format("waiting for countdown latch for resource %s", resource.getFilename()), (Throwable)e);
        }
        return synchronizedOutputStream;
    }

    public void delete() {
        if (this.gridfs.findOne(Query.query((CriteriaDefinition)GridFsCriteria.whereFilename().is((Object)this.location))) == null) {
            return;
        }
        this.gridfs.delete(Query.query((CriteriaDefinition)GridFsCriteria.whereFilename().is((Object)this.location)));
    }
}

