/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.mappings;

import internal.org.springframework.content.rest.annotations.ContentRestController;
import internal.org.springframework.content.rest.mappings.CorsConfigurationBuilder;
import internal.org.springframework.content.rest.utils.ContentStoreUtils;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.storeservice.ContentStoreInfo;
import org.springframework.content.commons.storeservice.ContentStoreService;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.UrlPathHelper;

public class ContentHandlerMapping
extends RequestMappingHandlerMapping {
    private static MediaType hal = MediaType.parseMediaType((String)"application/hal+json");
    private static MediaType json = MediaType.parseMediaType((String)"application/json");
    private ContentStoreService contentStores;

    public ContentHandlerMapping(ContentStoreService contentStores) {
        this.contentStores = contentStores;
        this.setOrder(0x7FFFFF37);
    }

    protected boolean isHandler(Class<?> beanType) {
        return AnnotationUtils.findAnnotation(beanType, ContentRestController.class) != null;
    }

    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest request) throws Exception {
        String[] path = lookupPath.split("/");
        if (path.length < 3) {
            return null;
        }
        ContentStoreInfo info2 = ContentStoreUtils.findStore(this.contentStores, path[1]);
        if (info2 != null && !this.isHalOrJsonRequest(request)) {
            return super.lookupHandlerMethod(lookupPath, request);
        }
        return null;
    }

    protected CorsConfiguration getCorsConfiguration(Object handler, HttpServletRequest request) {
        CorsConfiguration corsConfiguration = super.getCorsConfiguration(handler, request);
        String lookupPath = this.getUrlPathHelper().getLookupPathForRequest(request);
        String[] path = lookupPath.split("/");
        if (path.length < 3) {
            return corsConfiguration;
        }
        ContentStoreInfo info2 = ContentStoreUtils.findStore(this.contentStores, path[1]);
        if (info2 == null) {
            return corsConfiguration;
        }
        CorsConfigurationBuilder builder = new CorsConfigurationBuilder();
        CorsConfiguration storeCorsConfiguration = builder.build(info2.getInterface());
        return corsConfiguration == null ? storeCorsConfiguration : corsConfiguration.combine(storeCorsConfiguration);
    }

    private boolean isHalOrJsonRequest(HttpServletRequest request) {
        String contentType;
        String method = request.getMethod();
        if ("GET".equals(method) || "DELETE".equals(method)) {
            String accept = request.getHeader("Accept");
            if (accept != null) {
                try {
                    List mediaTypes = MediaType.parseMediaTypes((String)accept);
                    for (MediaType mediaType : mediaTypes) {
                        if (!mediaType.equals((Object)hal) && !mediaType.equals((Object)json)) continue;
                        return true;
                    }
                }
                catch (InvalidMediaTypeException imte) {
                    return true;
                }
            }
        } else if (("PUT".equals(method) || "POST".equals(method)) && (contentType = request.getHeader("Content-Type")) != null) {
            try {
                List mediaTypes = MediaType.parseMediaTypes((String)contentType);
                for (MediaType mediaType : mediaTypes) {
                    if (!mediaType.equals((Object)hal) && !mediaType.equals((Object)json)) continue;
                    return true;
                }
            }
            catch (InvalidMediaTypeException imte) {
                return true;
            }
        }
        return false;
    }

    protected void detectHandlerMethods(Object handler) {
        super.detectHandlerMethods(handler);
    }

    protected RequestCondition<?> getCustomMethodCondition(Method method) {
        StoreType typeAnnotation = (StoreType)AnnotationUtils.findAnnotation((Method)method, StoreType.class);
        if (typeAnnotation != null) {
            return new StoreCondition(typeAnnotation, this.contentStores);
        }
        return null;
    }

    public static class StoreCondition
    implements RequestCondition<StoreCondition> {
        private String storeType = "store";
        private ContentStoreService stores;

        public StoreCondition(StoreType typeAnnotation, ContentStoreService stores) {
            this.storeType = typeAnnotation.value();
            this.stores = stores;
        }

        public StoreCondition combine(StoreCondition other) {
            throw new UnsupportedOperationException();
        }

        public StoreCondition getMatchingCondition(HttpServletRequest request) {
            String path = new UrlPathHelper().getPathWithinApplication(request);
            String[] segments = path.split("/");
            if (segments.length < 3) {
                return null;
            }
            ContentStoreInfo info = ContentStoreUtils.findStore(this.stores, segments[1]);
            if (info != null && Store.class.isAssignableFrom(info.getInterface()) && "store".equals(this.storeType) || ContentStore.class.isAssignableFrom(info.getInterface()) && "contentstore".equals(this.storeType)) {
                return this;
            }
            return null;
        }

        public int compareTo(StoreCondition other, HttpServletRequest request) {
            if (this.isMappingForRequest(request) && !other.isMappingForRequest(request)) {
                return 1;
            }
            if (!this.isMappingForRequest(request) && other.isMappingForRequest(request)) {
                return -1;
            }
            String path = new UrlPathHelper().getPathWithinApplication(request);
            String filename = FilenameUtils.getName((String)path);
            String extension = FilenameUtils.getExtension((String)filename);
            if (extension != null && "store".equals(this.storeType)) {
                return -1;
            }
            if (extension != null && "contentstore".equals(this.storeType)) {
                return 1;
            }
            return 0;
        }

        public boolean isMappingForRequest(HttpServletRequest request) {
            String path = new UrlPathHelper().getPathWithinApplication(request);
            String[] segments = path.split("/");
            if (segments.length < 3) {
                return false;
            }
            ContentStoreInfo info = ContentStoreUtils.findStore(this.stores, segments[1]);
            return info != null && Store.class.isAssignableFrom(info.getInterface()) && "store".equals(this.storeType) || ContentStore.class.isAssignableFrom(info.getInterface()) && "contentstore".equals(this.storeType);
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface StoreType {
        public String value() default "store";
    }
}

