/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.utils;

import internal.org.springframework.content.rest.controllers.ResourceNotFoundException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.support.Repositories;

public final class PersistentEntityUtils {
    private PersistentEntityUtils() {
    }

    public static PersistentEntity<?, ?> findPersistentEntity(Repositories repositories, Class<?> domainType) {
        PersistentEntity persistentEntity = repositories.getPersistentEntity(domainType);
        return persistentEntity;
    }

    public static PersistentProperty<?> getPersistentProperty(PersistentEntity<?, ?> entity, String propertyName) {
        PersistentProperty prop = entity.getPersistentProperty(propertyName);
        if (null == prop) {
            throw new ResourceNotFoundException();
        }
        return prop;
    }

    public static boolean isPropertyMultiValued(PersistentProperty<?> prop) {
        return prop.isArray() || prop.isCollectionLike();
    }
}

