/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import internal.org.springframework.content.rest.controllers.BadRequestException;
import internal.org.springframework.content.rest.mappings.ContentHandlerMapping;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.search.Searchable;
import org.springframework.content.commons.storeservice.ContentStoreInfo;
import org.springframework.content.commons.storeservice.ContentStoreService;
import org.springframework.content.commons.storeservice.StoreFilter;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.commons.utils.ReflectionService;
import org.springframework.content.commons.utils.ReflectionServiceImpl;
import org.springframework.data.annotation.Id;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.webmvc.AbstractRepositoryRestController;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resources;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@RepositoryRestController
public class ContentSearchRestController
extends AbstractRepositoryRestController {
    private static final String ENTITY_CONTENTSEARCH_MAPPING = "/{repository}/searchContent/{searchMethod}";
    private static final String PROPERTY_CONTENTSEARCH_MAPPING = "/{repository}/searchContent/{contentProperty}/{searchMethod}";
    private static Map<String, Method> searchMethods = new HashMap<String, Method>();
    private Repositories repositories;
    private ContentStoreService stores;
    private ReflectionService reflectionService;

    @Autowired
    public ContentSearchRestController(Repositories repositories, ContentStoreService stores, PagedResourcesAssembler<Object> assembler) {
        super(assembler);
        this.repositories = repositories;
        this.stores = stores;
        this.reflectionService = new ReflectionServiceImpl();
    }

    public void setReflectionService(ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    @ContentHandlerMapping.StoreType(value="contentstore")
    @RequestMapping(value={"/{repository}/searchContent/{searchMethod}"}, method={RequestMethod.GET})
    public ResponseEntity<?> searchContent(final RootResourceInformation repoInfo, PersistentEntityResourceAssembler assembler, @PathVariable String repository, @PathVariable String searchMethod, @RequestParam(name="keyword") List<String> keywords) throws HttpRequestMethodNotSupportedException {
        ContentStoreInfo[] infos = this.stores.getStores(ContentStore.class, new StoreFilter(){

            public boolean matches(ContentStoreInfo info) {
                return repoInfo.getDomainType().equals(info.getDomainObjectClass());
            }
        });
        if (infos.length == 0) {
            throw new ResourceNotFoundException("Entity has no content associations");
        }
        if (infos.length > 1) {
            throw new IllegalStateException(String.format("Too many content assocation for Entity %s", repoInfo.getDomainType().getCanonicalName()));
        }
        ContentStoreInfo info = infos[0];
        ContentStore store = info.getImpementation();
        if (!(store instanceof Searchable)) {
            throw new ResourceNotFoundException("Entity content is not searchable");
        }
        Method method = searchMethods.get(searchMethod);
        if (method == null) {
            throw new ResourceNotFoundException(String.format("Invalid search: %s", searchMethod));
        }
        if (keywords == null || keywords.size() == 0) {
            throw new BadRequestException();
        }
        List contentIds = (List)this.reflectionService.invokeMethod(method, (Object)store, new Object[]{keywords.get(0)});
        if (contentIds != null && contentIds.size() > 0) {
            Class entityType = repoInfo.getDomainType();
            Field idField = BeanUtils.findFieldWithAnnotation((Class)entityType, Id.class);
            if (idField == null) {
                idField = BeanUtils.findFieldWithAnnotation((Class)entityType, javax.persistence.Id.class);
            }
            Field contentIdField = BeanUtils.findFieldWithAnnotation((Class)entityType, ContentId.class);
            ArrayList<Object> results = new ArrayList<Object>();
            if (idField.equals(contentIdField)) {
                for (Object contentId : contentIds) {
                    Object entity = repoInfo.getInvoker().invokeFindOne((Serializable)((Object)contentId.toString()));
                    results.add(entity);
                }
            } else {
                Pageable pageable = null;
                Iterable entities = repoInfo.getInvoker().invokeFindAll(pageable);
                for (Object entity : entities) {
                    for (Object contentId : contentIds) {
                        Object candidate;
                        if (!contentId.equals(candidate = BeanUtils.getFieldWithAnnotation(entity, ContentId.class))) continue;
                        results.add(entity);
                    }
                }
            }
            return ResponseEntity.ok((Object)this.toResources(results, assembler, entityType, null));
        }
        return ResponseEntity.ok((Object)new Resources(ControllerUtils.EMPTY_RESOURCE_LIST, new Link[0]));
    }

    static {
        searchMethods.put("findKeyword", ReflectionUtils.findMethod(Searchable.class, (String)"findKeyword", (Class[])new Class[]{String.class}));
    }
}

