/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.controllers;

import internal.org.springframework.content.rest.annotations.ContentRestController;
import internal.org.springframework.content.rest.controllers.AbstractContentPropertyController;
import internal.org.springframework.content.rest.controllers.ResourceNotFoundException;
import internal.org.springframework.content.rest.mappings.ContentHandlerMapping;
import internal.org.springframework.content.rest.mappings.StoreByteRangeHttpRequestHandler;
import internal.org.springframework.content.rest.utils.ContentStoreUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.annotations.MimeType;
import org.springframework.content.commons.annotations.OriginalFileName;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.storeservice.ContentStoreInfo;
import org.springframework.content.commons.storeservice.ContentStoreService;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.data.repository.support.Repositories;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@ContentRestController
public class ContentEntityRestController
extends AbstractContentPropertyController {
    private static final String BASE_MAPPING = "/{store}/{id}";
    private Repositories repositories;
    private ContentStoreService storeService;
    private StoreByteRangeHttpRequestHandler handler;

    @Autowired
    public ContentEntityRestController(ApplicationContext context, ContentStoreService storeService, StoreByteRangeHttpRequestHandler handler) {
        try {
            this.repositories = (Repositories)context.getBean(Repositories.class);
        }
        catch (BeansException be) {
            this.repositories = new Repositories((ListableBeanFactory)context);
        }
        this.storeService = storeService;
        this.handler = handler;
    }

    @ContentHandlerMapping.StoreType(value="contentstore")
    @RequestMapping(value={"/{store}/{id}"}, method={RequestMethod.GET}, headers={"accept!=application/hal+json", "range"})
    public void getContent(HttpServletRequest request, HttpServletResponse response, @PathVariable String store, @PathVariable String id) throws HttpRequestMethodNotSupportedException {
        ContentStoreInfo info = ContentStoreUtils.findStore(this.storeService, store);
        if (info == null) {
            throw new IllegalArgumentException(String.format("Store for path %s not found", store));
        }
        Object domainObj = ContentEntityRestController.findOne(this.repositories, info.getDomainObjectClass(), id);
        Serializable cid = (Serializable)BeanUtils.getFieldWithAnnotation((Object)domainObj, ContentId.class);
        Resource r = ((Store)info.getImpementation()).getResource(cid);
        if (r == null) {
            throw new ResourceNotFoundException();
        }
        request.setAttribute("SPRING_CONTENT_RESOURCE", (Object)r);
        if (BeanUtils.hasFieldWithAnnotation((Object)domainObj, MimeType.class)) {
            request.setAttribute("SPRING_CONTENT_CONTENTTYPE", (Object)BeanUtils.getFieldWithAnnotation((Object)domainObj, MimeType.class).toString());
        }
        try {
            this.handler.handleRequest(request, response);
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @ContentHandlerMapping.StoreType(value="contentstore")
    @RequestMapping(value={"/{store}/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<InputStreamResource> getContent(@PathVariable String store, @PathVariable String id, @RequestHeader(value="Accept", required=false) String mimeType) throws HttpRequestMethodNotSupportedException {
        ContentStoreInfo info = ContentStoreUtils.findStore(this.storeService, store);
        if (info == null) {
            throw new IllegalArgumentException(String.format("Store for path %s not found", store));
        }
        Object domainObj = ContentEntityRestController.findOne(this.repositories, info.getDomainObjectClass(), id);
        Object contentId = BeanUtils.getFieldWithAnnotation((Object)domainObj, ContentId.class);
        if (contentId == null) {
            throw new ResourceNotFoundException();
        }
        ArrayList<MediaType> mimeTypes = new ArrayList<MediaType>(MediaType.parseMediaTypes((String)mimeType));
        if (mimeTypes.size() == 0) {
            mimeTypes.add(MediaType.ALL);
        }
        HttpHeaders headers = new HttpHeaders();
        ContentStore storeImpl = info.getImpementation();
        InputStream content = ContentStoreUtils.getContent((ContentStore<Object, Serializable>)storeImpl, domainObj, mimeTypes, headers);
        if (content != null) {
            InputStreamResource inputStreamResource = new InputStreamResource(content);
            return new ResponseEntity((Object)inputStreamResource, (MultiValueMap)headers, HttpStatus.OK);
        }
        return new ResponseEntity(null, (MultiValueMap)headers, HttpStatus.NOT_ACCEPTABLE);
    }

    @ContentHandlerMapping.StoreType(value="contentstore")
    @RequestMapping(value={"/{store}/{id}"}, method={RequestMethod.PUT}, headers={"content-type!=multipart/form-data", "accept!=application/hal+json"})
    @ResponseBody
    public void putContent(HttpServletRequest request, HttpServletResponse response, @PathVariable String store, @PathVariable String id) throws IOException, HttpRequestMethodNotSupportedException, InstantiationException, IllegalAccessException {
        ContentStoreInfo info = ContentStoreUtils.findContentStore(this.storeService, store);
        if (info == null) {
            throw new IllegalArgumentException(String.format("Store for path %s not found", store));
        }
        Object domainObj = ContentEntityRestController.findOne(this.repositories, info.getDomainObjectClass(), id);
        boolean isNew = true;
        if (BeanUtils.hasFieldWithAnnotation((Object)domainObj, ContentId.class)) {
            isNew = BeanUtils.getFieldWithAnnotation((Object)domainObj, ContentId.class) == null;
        }
        info.getImpementation().setContent(domainObj, (InputStream)request.getInputStream());
        if (BeanUtils.hasFieldWithAnnotation((Object)domainObj, MimeType.class)) {
            BeanUtils.setFieldWithAnnotation((Object)domainObj, MimeType.class, (Object)request.getHeader("Content-Type"));
        }
        ContentEntityRestController.save(this.repositories, domainObj);
        if (isNew) {
            response.setStatus(HttpStatus.CREATED.value());
        } else {
            response.setStatus(HttpStatus.OK.value());
        }
    }

    @ContentHandlerMapping.StoreType(value="contentstore")
    @RequestMapping(value={"/{store}/{id}"}, method={RequestMethod.PUT}, headers={"content-type=multipart/form-data"})
    @ResponseBody
    public void putMultipartContent(HttpServletResponse response, @PathVariable String store, @PathVariable String id, @RequestParam(value="file") MultipartFile multiPart) throws IOException, HttpRequestMethodNotSupportedException, InstantiationException, IllegalAccessException {
        this.handleMultipart(response, store, id, multiPart);
    }

    @ContentHandlerMapping.StoreType(value="contentstore")
    @RequestMapping(value={"/{store}/{id}"}, method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    @ResponseBody
    public void postMultipartContent(HttpServletResponse response, @PathVariable String store, @PathVariable String id, @RequestParam(value="file") MultipartFile multiPart) throws IOException, HttpRequestMethodNotSupportedException, InstantiationException, IllegalAccessException {
        this.handleMultipart(response, store, id, multiPart);
    }

    @ContentHandlerMapping.StoreType(value="contentstore")
    @RequestMapping(value={"/{store}/{id}"}, method={RequestMethod.DELETE}, headers={"accept!=application/hal+json"})
    public void deleteContent(HttpServletResponse response, @PathVariable String store, @PathVariable String id) throws HttpRequestMethodNotSupportedException, IOException {
        ContentStoreInfo info = ContentStoreUtils.findContentStore(this.storeService, store);
        if (info == null) {
            throw new IllegalArgumentException(String.format("Store for path %s not found", store));
        }
        Object domainObj = ContentEntityRestController.findOne(this.repositories, info.getDomainObjectClass(), id);
        try (InputStream content = info.getImpementation().getContent(domainObj);){
            if (content == null) {
                throw new ResourceNotFoundException();
            }
        }
        info.getImpementation().unsetContent(domainObj);
        if (BeanUtils.hasFieldWithAnnotation((Object)domainObj, MimeType.class)) {
            BeanUtils.setFieldWithAnnotation((Object)domainObj, MimeType.class, null);
        }
        ContentEntityRestController.save(this.repositories, domainObj);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected void handleMultipart(HttpServletResponse response, String store, String id, MultipartFile multiPart) throws HttpRequestMethodNotSupportedException, IOException {
        String originalFileName;
        ContentStoreInfo info = ContentStoreUtils.findContentStore(this.storeService, store);
        if (info == null) {
            throw new IllegalArgumentException(String.format("Store for path %s not found", store));
        }
        Object domainObj = ContentEntityRestController.findOne(this.repositories, info.getDomainObjectClass(), id);
        info.getImpementation().setContent(domainObj, multiPart.getInputStream());
        if (BeanUtils.hasFieldWithAnnotation((Object)domainObj, MimeType.class)) {
            BeanUtils.setFieldWithAnnotation((Object)domainObj, MimeType.class, (Object)multiPart.getContentType());
        }
        if ((originalFileName = multiPart.getOriginalFilename()) != null && StringUtils.hasText((String)originalFileName) && BeanUtils.hasFieldWithAnnotation((Object)domainObj, OriginalFileName.class)) {
            BeanUtils.setFieldWithAnnotation((Object)domainObj, OriginalFileName.class, (Object)originalFileName);
        }
        boolean isNew = true;
        if (BeanUtils.hasFieldWithAnnotation((Object)domainObj, ContentId.class)) {
            isNew = BeanUtils.getFieldWithAnnotation((Object)domainObj, ContentId.class) == null;
        }
        ContentEntityRestController.save(this.repositories, domainObj);
        if (isNew) {
            response.setStatus(HttpStatus.CREATED.value());
        } else {
            response.setStatus(HttpStatus.OK.value());
        }
    }
}

