/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.links;

import internal.org.springframework.content.rest.utils.ContentStoreUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.storeservice.ContentStoreInfo;
import org.springframework.content.commons.storeservice.ContentStoreService;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.ResourceProcessor;
import org.springframework.hateoas.mvc.BasicLinkBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ContentLinksResourceProcessor
implements ResourceProcessor<PersistentEntityResource> {
    private static final Log log = LogFactory.getLog(ContentLinksResourceProcessor.class);
    private ContentStoreService stores;

    public ContentLinksResourceProcessor(ContentStoreService stores) {
        this.stores = stores;
    }

    public PersistentEntityResource process(PersistentEntityResource resource) {
        Object id;
        Object object = resource.getContent();
        if (object == null) {
            return resource;
        }
        ContentStoreInfo store = ContentStoreUtils.findContentStore(this.stores, object.getClass());
        if (store != null && (id = BeanUtils.getFieldWithAnnotation((Object)object, ContentId.class)) != null) {
            resource.add(((BasicLinkBuilder)((BasicLinkBuilder)BasicLinkBuilder.linkToCurrentMapping().slash((Object)ContentStoreUtils.storePath(store))).slash(id)).withRel(ContentStoreUtils.storePath(store)));
        }
        ArrayList<Field> processed = new ArrayList<Field>();
        for (Field field : object.getClass().getFields()) {
            processed.add(field);
            this.handleField(field, resource);
        }
        BeanWrapperImpl wrapper = new BeanWrapperImpl(object);
        for (PropertyDescriptor descriptor : wrapper.getPropertyDescriptors()) {
            Field field = null;
            try {
                field = object.getClass().getDeclaredField(descriptor.getName());
                if (processed.contains(field)) continue;
                this.handleField(field, resource);
            }
            catch (NoSuchFieldException nsfe) {
                log.trace((Object)String.format("No field for property %s, ignoring", descriptor.getName()));
            }
            catch (SecurityException se) {
                log.warn((Object)String.format("Unexpected security error while handling content links for property %s", descriptor.getName()));
            }
        }
        return resource;
    }

    private void handleField(Field field, PersistentEntityResource resource) {
        Class fieldType = field.getType();
        if (fieldType.isArray()) {
            ContentStoreInfo store = ContentStoreUtils.findContentStore(this.stores, fieldType = fieldType.getComponentType());
            if (store != null) {
                resource.add(new Link(resource.getLink("self").getHref() + "/" + field.getName(), field.getName()));
            }
        } else if (Collection.class.isAssignableFrom(fieldType)) {
            Type type = field.getGenericType();
            if (type instanceof ParameterizedType) {
                Type[] arr;
                ParameterizedType pType = (ParameterizedType)type;
                for (Type tp : arr = pType.getActualTypeArguments()) {
                    fieldType = (Class)tp;
                }
                ContentStoreInfo store = ContentStoreUtils.findContentStore(this.stores, fieldType);
                if (store != null) {
                    Object object = resource.getContent();
                    BeanWrapperImpl wrapper = new BeanWrapperImpl(object);
                    Object value = null;
                    try {
                        value = wrapper.getPropertyValue(field.getName());
                    }
                    catch (InvalidPropertyException ipe) {
                        try {
                            value = ReflectionUtils.getField((Field)field, (Object)object);
                        }
                        catch (IllegalStateException ise) {
                            log.trace((Object)String.format("Didn't get value for property %s", field.getName()));
                        }
                    }
                    if (value != null) {
                        int i = 0;
                        for (Object o : (Collection)value) {
                            if (BeanUtils.hasFieldWithAnnotation(o, ContentId.class)) {
                                String cid = BeanUtils.getFieldWithAnnotation(o, ContentId.class).toString();
                                resource.add(new Link(resource.getLink("self").getHref() + "/" + field.getName() + "/" + cid, field.getName()));
                                BasicLinkBuilder lb = BasicLinkBuilder.linkToCurrentMapping();
                                boolean bl = false;
                            }
                            ++i;
                        }
                    }
                }
            }
        } else {
            ContentStoreInfo store = ContentStoreUtils.findContentStore(this.stores, fieldType);
            if (store != null) {
                Object object = resource.getContent();
                BeanWrapperImpl wrapper = new BeanWrapperImpl(object);
                Object value = null;
                try {
                    value = wrapper.getPropertyValue(field.getName());
                }
                catch (InvalidPropertyException ipe) {
                    try {
                        value = ReflectionUtils.getField((Field)field, (Object)object);
                    }
                    catch (IllegalStateException ise) {
                        log.trace((Object)String.format("Didn't get value for property %s", field.getName()));
                    }
                }
                if (value != null) {
                    String id = BeanUtils.getFieldWithAnnotation((Object)value, ContentId.class).toString();
                    Assert.notNull((Object)id);
                    resource.add(new Link(resource.getLink("self").getHref() + "/" + field.getName() + "/" + id, field.getName()));
                }
            }
        }
    }
}

