/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import internal.org.springframework.content.rest.controllers.BadRequestException;
import internal.org.springframework.content.rest.mappings.ContentHandlerMapping;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.search.Searchable;
import org.springframework.content.commons.storeservice.ContentStoreInfo;
import org.springframework.content.commons.storeservice.ContentStoreService;
import org.springframework.content.commons.storeservice.StoreFilter;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.commons.utils.ReflectionService;
import org.springframework.content.commons.utils.ReflectionServiceImpl;
import org.springframework.data.annotation.Id;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.core.EmbeddedWrappers;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RepositoryRestController
public class ContentSearchRestController {
    private static final EmbeddedWrappers WRAPPERS = new EmbeddedWrappers(false);
    private static final String ENTITY_CONTENTSEARCH_MAPPING = "/{repository}/searchContent/{searchMethod}";
    private static final String PROPERTY_CONTENTSEARCH_MAPPING = "/{repository}/searchContent/{contentProperty}/{searchMethod}";
    private static Map<String, Method> searchMethods = new HashMap<String, Method>();
    private Repositories repositories;
    private ContentStoreService stores;
    private PagedResourcesAssembler<Object> pagedResourcesAssembler;
    private ReflectionService reflectionService;

    @Autowired
    public ContentSearchRestController(Repositories repositories, ContentStoreService stores, PagedResourcesAssembler<Object> assembler) {
        this.repositories = repositories;
        this.stores = stores;
        this.pagedResourcesAssembler = assembler;
        this.reflectionService = new ReflectionServiceImpl();
    }

    public void setReflectionService(ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    @ContentHandlerMapping.StoreType(value="contentstore")
    @RequestMapping(value={"/{repository}/searchContent/{searchMethod}"}, method={RequestMethod.GET})
    public ResponseEntity<?> searchContent(final RootResourceInformation repoInfo, PersistentEntityResourceAssembler assembler, @PathVariable String repository, @PathVariable String searchMethod, @RequestParam(name="keyword") List<String> keywords) throws HttpRequestMethodNotSupportedException {
        ContentStoreInfo[] infos = this.stores.getStores(ContentStore.class, new StoreFilter(){

            public boolean matches(ContentStoreInfo info) {
                return repoInfo.getDomainType().equals(info.getDomainObjectClass());
            }
        });
        if (infos.length == 0) {
            throw new ResourceNotFoundException("Entity has no content associations");
        }
        if (infos.length > 1) {
            throw new IllegalStateException(String.format("Too many content assocation for Entity %s", repoInfo.getDomainType().getCanonicalName()));
        }
        ContentStoreInfo info = infos[0];
        ContentStore store = info.getImpementation();
        if (!(store instanceof Searchable)) {
            throw new ResourceNotFoundException("Entity content is not searchable");
        }
        Method method = searchMethods.get(searchMethod);
        if (method == null) {
            throw new ResourceNotFoundException(String.format("Invalid search: %s", searchMethod));
        }
        if (keywords == null || keywords.size() == 0) {
            throw new BadRequestException();
        }
        List contentIds = (List)this.reflectionService.invokeMethod(method, (Object)store, new Object[]{keywords.get(0)});
        if (contentIds != null && contentIds.size() > 0) {
            Class entityType = repoInfo.getDomainType();
            Field idField = BeanUtils.findFieldWithAnnotation((Class)entityType, Id.class);
            if (idField == null) {
                idField = BeanUtils.findFieldWithAnnotation((Class)entityType, javax.persistence.Id.class);
            }
            Field contentIdField = BeanUtils.findFieldWithAnnotation((Class)entityType, ContentId.class);
            ArrayList results = new ArrayList();
            if (idField.equals(contentIdField)) {
                for (Object contentId : contentIds) {
                    Optional entity = repoInfo.getInvoker().invokeFindById((Object)contentId.toString());
                    if (!entity.isPresent()) continue;
                    results.add(entity.get());
                }
            } else {
                Pageable pageable = null;
                Iterable entities = repoInfo.getInvoker().invokeFindAll(pageable);
                for (Object entity : entities) {
                    for (Object contentId : contentIds) {
                        Object candidate;
                        if (!contentId.equals(candidate = BeanUtils.getFieldWithAnnotation(entity, ContentId.class))) continue;
                        results.add(entity);
                    }
                }
            }
            return ResponseEntity.ok(this.toResources(results, assembler, entityType, null));
        }
        return ResponseEntity.ok((Object)new Resources(ControllerUtils.EMPTY_RESOURCE_LIST, new Link[0]));
    }

    protected Resources<?> toResources(Iterable<?> source, PersistentEntityResourceAssembler assembler, Class<?> domainType, Link baseLink) {
        if (source instanceof Page) {
            Page page = (Page)source;
            return this.entitiesToResources((Page<Object>)page, assembler, domainType, baseLink);
        }
        if (source instanceof Iterable) {
            return this.entitiesToResources(source, assembler, domainType);
        }
        return new Resources(ControllerUtils.EMPTY_RESOURCE_LIST, new Link[0]);
    }

    protected Resources<?> entitiesToResources(Page<Object> page, PersistentEntityResourceAssembler assembler, Class<?> domainType, Link baseLink) {
        if (page.getContent().isEmpty()) {
            return this.pagedResourcesAssembler.toEmptyResource(page, domainType, baseLink);
        }
        return baseLink == null ? this.pagedResourcesAssembler.toResource(page, (ResourceAssembler)assembler) : this.pagedResourcesAssembler.toResource(page, (ResourceAssembler)assembler, baseLink);
    }

    protected Resources<?> entitiesToResources(Iterable<Object> entities, PersistentEntityResourceAssembler assembler, Class<?> domainType) {
        if (!entities.iterator().hasNext()) {
            List<Object> content = Arrays.asList(WRAPPERS.emptyCollectionOf(domainType));
            return new Resources(content, new Link[]{this.getDefaultSelfLink()});
        }
        ArrayList<PersistentEntityResource> resources = new ArrayList<PersistentEntityResource>();
        for (Object obj : entities) {
            resources.add(obj == null ? null : assembler.toResource(obj));
        }
        return new Resources(resources, new Link[]{this.getDefaultSelfLink()});
    }

    protected Link getDefaultSelfLink() {
        return new Link(ServletUriComponentsBuilder.fromCurrentRequest().build().toUriString());
    }

    static {
        searchMethods.put("findKeyword", ReflectionUtils.findMethod(Searchable.class, (String)"findKeyword", (Class[])new Class[]{String.class}));
    }
}

