/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.controllers;

import internal.org.springframework.content.rest.annotations.ContentRestController;
import internal.org.springframework.content.rest.controllers.AbstractContentPropertyController;
import internal.org.springframework.content.rest.controllers.ResourceNotFoundException;
import internal.org.springframework.content.rest.mappings.ContentHandlerMapping;
import internal.org.springframework.content.rest.mappings.StoreByteRangeHttpRequestHandler;
import internal.org.springframework.content.rest.utils.ContentStoreUtils;
import internal.org.springframework.content.rest.utils.HeaderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.Version;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.annotations.MimeType;
import org.springframework.content.commons.annotations.OriginalFileName;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.storeservice.ContentStoreInfo;
import org.springframework.content.commons.storeservice.ContentStoreService;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.repository.support.Repositories;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@ContentRestController
public class ContentEntityRestController
extends AbstractContentPropertyController {
    private static final Logger logger = LoggerFactory.getLogger(ContentEntityRestController.class);
    private static final String BASE_MAPPING = "/{store}/{id}";
    private Repositories repositories;
    private ContentStoreService storeService;
    private StoreByteRangeHttpRequestHandler handler;

    @Autowired
    public ContentEntityRestController(ApplicationContext context, ContentStoreService storeService, StoreByteRangeHttpRequestHandler handler) {
        try {
            this.repositories = (Repositories)context.getBean(Repositories.class);
        }
        catch (BeansException be) {
            this.repositories = new Repositories((ListableBeanFactory)context);
        }
        this.storeService = storeService;
        this.handler = handler;
    }

    @ContentHandlerMapping.StoreType(value="contentstore")
    @RequestMapping(value={"/{store}/{id}"}, method={RequestMethod.GET})
    public void getContent(HttpServletRequest request, HttpServletResponse response, @PathVariable String store, @PathVariable String id, @RequestHeader(value="Accept", required=false) String mimeType) throws HttpRequestMethodNotSupportedException {
        ContentStore storeImpl;
        ContentStoreUtils.ResourcePlan r;
        ContentStoreInfo info = ContentStoreUtils.findStore(this.storeService, store);
        if (info == null) {
            throw new IllegalArgumentException(String.format("Store for path %s not found", store));
        }
        Object domainObj = ContentEntityRestController.findOne(this.repositories, info.getDomainObjectClass(), id);
        Object contentId = BeanUtils.getFieldWithAnnotation((Object)domainObj, ContentId.class);
        if (contentId == null) {
            throw new ResourceNotFoundException();
        }
        ArrayList<MediaType> mimeTypes = new ArrayList<MediaType>(MediaType.parseMediaTypes((String)mimeType));
        if (mimeTypes.size() == 0) {
            mimeTypes.add(MediaType.ALL);
        }
        if (!(r = ContentStoreUtils.resolveResource((ContentStore<Object, Serializable>)(storeImpl = info.getImpementation()), domainObj, null, mimeTypes)).getResource().exists()) {
            throw new ResourceNotFoundException();
        }
        Object version = BeanUtils.getFieldWithAnnotation((Object)domainObj, Version.class);
        long lastModified = -1L;
        try {
            lastModified = r.getResource().lastModified();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (new ServletWebRequest(request, response).checkNotModified(version != null ? version.toString() : null, lastModified)) {
            return;
        }
        request.setAttribute("SPRING_CONTENT_RESOURCE", (Object)r.getResource());
        request.setAttribute("SPRING_CONTENT_CONTENTTYPE", (Object)r.getMimeType());
        try {
            this.handler.handleRequest(request, response);
        }
        catch (Exception e) {
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Failed to handle request for %s", id), (Throwable)e);
        }
    }

    @ContentHandlerMapping.StoreType(value="contentstore")
    @RequestMapping(value={"/{store}/{id}"}, method={RequestMethod.PUT}, headers={"content-type!=multipart/form-data", "accept!=application/hal+json"})
    @ResponseBody
    public void putContent(HttpServletRequest request, HttpServletResponse response, @RequestHeader HttpHeaders headers, @PathVariable String store, @PathVariable String id) throws IOException, HttpRequestMethodNotSupportedException {
        this.handleMultipart(request, response, headers, store, id, (InputStream)request.getInputStream(), headers.getContentType(), null);
    }

    @ContentHandlerMapping.StoreType(value="contentstore")
    @RequestMapping(value={"/{store}/{id}"}, method={RequestMethod.PUT}, headers={"content-type=multipart/form-data"})
    @ResponseBody
    public void putMultipartContent(HttpServletRequest request, HttpServletResponse response, @RequestHeader HttpHeaders headers, @PathVariable String store, @PathVariable String id, @RequestParam(value="file") MultipartFile multiPart) throws IOException, HttpRequestMethodNotSupportedException {
        this.handleMultipart(request, response, headers, store, id, multiPart.getInputStream(), MediaType.parseMediaType((String)multiPart.getContentType()), multiPart.getOriginalFilename());
    }

    @ContentHandlerMapping.StoreType(value="contentstore")
    @RequestMapping(value={"/{store}/{id}"}, method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    @ResponseBody
    public void postMultipartContent(HttpServletRequest request, HttpServletResponse response, @RequestHeader HttpHeaders headers, @PathVariable String store, @PathVariable String id, @RequestParam(value="file") MultipartFile multiPart) throws IOException, HttpRequestMethodNotSupportedException {
        this.handleMultipart(request, response, headers, store, id, multiPart.getInputStream(), MediaType.parseMediaType((String)multiPart.getContentType()), multiPart.getOriginalFilename());
    }

    @ContentHandlerMapping.StoreType(value="contentstore")
    @RequestMapping(value={"/{store}/{id}"}, method={RequestMethod.DELETE}, headers={"accept!=application/hal+json"})
    public void deleteContent(@RequestHeader HttpHeaders headers, HttpServletResponse response, @PathVariable String store, @PathVariable String id) throws HttpRequestMethodNotSupportedException, IOException {
        ContentStoreInfo info = ContentStoreUtils.findContentStore(this.storeService, store);
        if (info == null) {
            throw new IllegalArgumentException(String.format("Store for path %s not found", store));
        }
        Object domainObj = ContentEntityRestController.findOne(this.repositories, info.getDomainObjectClass(), id);
        String etag = BeanUtils.getFieldWithAnnotation((Object)domainObj, Version.class) != null ? BeanUtils.getFieldWithAnnotation((Object)domainObj, Version.class).toString() : null;
        Object lastModifiedDate = BeanUtils.getFieldWithAnnotation((Object)domainObj, LastModifiedDate.class) != null ? BeanUtils.getFieldWithAnnotation((Object)domainObj, LastModifiedDate.class) : null;
        HeaderUtils.evaluateHeaderConditions(headers, etag, lastModifiedDate);
        try (InputStream content = info.getImpementation().getContent(domainObj);){
            if (content == null) {
                throw new ResourceNotFoundException();
            }
        }
        domainObj = info.getImpementation().unsetContent(domainObj);
        if (BeanUtils.hasFieldWithAnnotation((Object)domainObj, MimeType.class)) {
            BeanUtils.setFieldWithAnnotation((Object)domainObj, MimeType.class, null);
        }
        ContentEntityRestController.save(this.repositories, domainObj);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected void handleMultipart(HttpServletRequest request, HttpServletResponse response, HttpHeaders headers, String store, String id, InputStream content, MediaType mimeType, String originalFilename) throws HttpRequestMethodNotSupportedException, IOException {
        ContentStoreInfo info = ContentStoreUtils.findContentStore(this.storeService, store);
        if (info == null) {
            throw new IllegalArgumentException(String.format("Store for path %s not found", store));
        }
        Object domainObj = ContentEntityRestController.findOne(this.repositories, info.getDomainObjectClass(), id);
        String etag = BeanUtils.getFieldWithAnnotation((Object)domainObj, Version.class) != null ? BeanUtils.getFieldWithAnnotation((Object)domainObj, Version.class).toString() : null;
        Object lastModifiedDate = BeanUtils.getFieldWithAnnotation((Object)domainObj, LastModifiedDate.class) != null ? BeanUtils.getFieldWithAnnotation((Object)domainObj, LastModifiedDate.class) : null;
        HeaderUtils.evaluateHeaderConditions(headers, etag, lastModifiedDate);
        boolean isNew = true;
        if (BeanUtils.hasFieldWithAnnotation((Object)domainObj, ContentId.class)) {
            boolean bl = isNew = BeanUtils.getFieldWithAnnotation((Object)domainObj, ContentId.class) == null;
        }
        if (BeanUtils.hasFieldWithAnnotation((Object)domainObj, MimeType.class)) {
            BeanUtils.setFieldWithAnnotation((Object)domainObj, MimeType.class, (Object)mimeType.toString());
        }
        if (originalFilename != null && StringUtils.hasText((String)originalFilename) && BeanUtils.hasFieldWithAnnotation((Object)domainObj, OriginalFileName.class)) {
            BeanUtils.setFieldWithAnnotation((Object)domainObj, OriginalFileName.class, (Object)originalFilename);
        }
        domainObj = info.getImpementation().setContent(domainObj, content);
        ContentEntityRestController.save(this.repositories, domainObj);
        if (isNew) {
            response.setStatus(HttpStatus.CREATED.value());
        } else {
            response.setStatus(HttpStatus.OK.value());
        }
    }
}

