/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.controllers;

import internal.org.springframework.content.rest.annotations.ContentRestController;
import internal.org.springframework.content.rest.controllers.AbstractContentPropertyController;
import internal.org.springframework.content.rest.mappings.ContentHandlerMapping;
import internal.org.springframework.content.rest.mappings.StoreByteRangeHttpRequestHandler;
import internal.org.springframework.content.rest.utils.ContentPropertyUtils;
import internal.org.springframework.content.rest.utils.ContentStoreUtils;
import internal.org.springframework.content.rest.utils.HeaderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Version;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.annotations.Content;
import org.springframework.content.commons.annotations.MimeType;
import org.springframework.content.commons.annotations.OriginalFileName;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.storeservice.ContentStoreInfo;
import org.springframework.content.commons.storeservice.ContentStoreService;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.support.Repositories;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@ContentRestController
public class ContentPropertyRestController
extends AbstractContentPropertyController {
    private static final String BASE_MAPPING = "/{repository}/{id}/{contentProperty}/{contentId}";
    private Repositories repositories;
    private ContentStoreService storeService;
    private StoreByteRangeHttpRequestHandler handler;

    @Autowired
    public ContentPropertyRestController(ApplicationContext context, ContentStoreService storeService, StoreByteRangeHttpRequestHandler handler) {
        try {
            this.repositories = (Repositories)context.getBean(Repositories.class);
        }
        catch (BeansException be) {
            this.repositories = new Repositories((ListableBeanFactory)context);
        }
        this.storeService = storeService;
        this.handler = handler;
    }

    @ContentHandlerMapping.StoreType(value="contentstore")
    @RequestMapping(value={"/{repository}/{id}/{contentProperty}/{contentId}"}, method={RequestMethod.GET})
    public void getContent(HttpServletRequest request, HttpServletResponse response, @PathVariable String repository, @PathVariable String id, @PathVariable String contentProperty, @PathVariable String contentId, @RequestHeader(value="Accept") String mimeType) throws HttpRequestMethodNotSupportedException {
        Object domainObj = ContentPropertyRestController.findOne(this.repositories, repository, id);
        Object contentPropertyValue = null;
        Class<?> contentEntityClass = null;
        if (domainObj.getClass().isAnnotationPresent(Content.class)) {
            contentPropertyValue = domainObj;
            contentEntityClass = domainObj.getClass();
        } else {
            PersistentProperty<?> property = this.getContentPropertyDefinition(this.repositories.getPersistentEntity(domainObj.getClass()), contentProperty);
            contentEntityClass = ContentPropertyUtils.getContentPropertyType(property);
            contentPropertyValue = this.getContentProperty(domainObj, property, contentId);
        }
        ContentStoreInfo info = ContentStoreUtils.findContentStore(this.storeService, contentEntityClass);
        if (info == null) {
            throw new IllegalArgumentException(String.format("Store for entity class %s not found", contentEntityClass.getCanonicalName()));
        }
        List mimeTypes = MediaType.parseMediaTypes((String)mimeType);
        if (mimeTypes.size() == 0) {
            mimeTypes.add(MediaType.ALL);
        }
        HttpHeaders headers = new HttpHeaders();
        ContentStore store = info.getImpementation();
        ContentStoreUtils.ResourcePlan r = ContentStoreUtils.resolveResource((ContentStore<Object, Serializable>)store, domainObj, contentPropertyValue, mimeTypes);
        Object version = BeanUtils.getFieldWithAnnotation((Object)domainObj, Version.class);
        long lastModified = -1L;
        try {
            lastModified = r.getResource().lastModified();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (new ServletWebRequest(request, response).checkNotModified(version != null ? version.toString() : null, lastModified)) {
            return;
        }
        request.setAttribute("SPRING_CONTENT_RESOURCE", (Object)r.getResource());
        request.setAttribute("SPRING_CONTENT_CONTENTTYPE", (Object)r.getMimeType());
        try {
            this.handler.handleRequest(request, response);
        }
        catch (Exception e) {
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Failed to handle request for %s", id), (Throwable)e);
        }
    }

    @ContentHandlerMapping.StoreType(value="contentstore")
    @RequestMapping(value={"/{repository}/{id}/{contentProperty}/{contentId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public void setContent(HttpServletRequest request, @RequestHeader HttpHeaders headers, @PathVariable String repository, @PathVariable String id, @PathVariable String contentProperty, @PathVariable String contentId) throws IOException, HttpRequestMethodNotSupportedException {
        this.replaceContentInternal(headers, this.repositories, this.storeService, repository, id, contentProperty, contentId, request.getHeader("Content-Type"), null, (InputStream)request.getInputStream());
    }

    @ContentHandlerMapping.StoreType(value="contentstore")
    @RequestMapping(value={"/{repository}/{id}/{contentProperty}/{contentId}"}, method={RequestMethod.POST}, headers={"content-type!=multipart/form-data"})
    @ResponseBody
    public void postContent(HttpServletRequest request, @RequestHeader HttpHeaders headers, @PathVariable String repository, @PathVariable String id, @PathVariable String contentProperty, @PathVariable String contentId) throws IOException, HttpRequestMethodNotSupportedException {
        this.replaceContentInternal(headers, this.repositories, this.storeService, repository, id, contentProperty, contentId, request.getHeader("Content-Type"), null, (InputStream)request.getInputStream());
    }

    @ContentHandlerMapping.StoreType(value="contentstore")
    @RequestMapping(value={"/{repository}/{id}/{contentProperty}/{contentId}"}, method={RequestMethod.POST}, headers={"content-type=multipart/form-data"})
    @ResponseBody
    public void postMultipartContent(@RequestHeader HttpHeaders headers, @PathVariable String repository, @PathVariable String id, @PathVariable String contentProperty, @PathVariable String contentId, @RequestParam(value="file") MultipartFile multiPart) throws IOException, HttpRequestMethodNotSupportedException {
        this.replaceContentInternal(headers, this.repositories, this.storeService, repository, id, contentProperty, contentId, multiPart.getContentType(), multiPart.getOriginalFilename(), multiPart.getInputStream());
    }

    @ContentHandlerMapping.StoreType(value="contentstore")
    @RequestMapping(value={"/{repository}/{id}/{contentProperty}/{contentId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> deleteContent(@RequestHeader HttpHeaders headers, @PathVariable String repository, @PathVariable String id, @PathVariable String contentProperty, @PathVariable String contentId) throws HttpRequestMethodNotSupportedException {
        Object domainObj = ContentPropertyRestController.findOne(this.repositories, repository, id);
        String etag = BeanUtils.getFieldWithAnnotation((Object)domainObj, Version.class) != null ? BeanUtils.getFieldWithAnnotation((Object)domainObj, Version.class).toString() : null;
        Object lastModifiedDate = BeanUtils.getFieldWithAnnotation((Object)domainObj, LastModifiedDate.class) != null ? BeanUtils.getFieldWithAnnotation((Object)domainObj, LastModifiedDate.class) : null;
        HeaderUtils.evaluateHeaderConditions(headers, etag, lastModifiedDate);
        PersistentProperty<?> property = this.getContentPropertyDefinition(this.repositories.getPersistentEntity(domainObj.getClass()), contentProperty);
        Object contentPropertyValue = this.getContentProperty(domainObj, property, contentId);
        Class<?> contentEntityClass = ContentPropertyUtils.getContentPropertyType(property);
        ContentStoreInfo info = ContentStoreUtils.findContentStore(this.storeService, contentEntityClass);
        info.getImpementation().unsetContent(contentPropertyValue);
        ContentPropertyRestController.save(this.repositories, domainObj);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private void replaceContentInternal(HttpHeaders headers, Repositories repositories, ContentStoreService stores, String repository, String id, String contentProperty, String contentId, String mimeType, String originalFileName, InputStream stream) throws HttpRequestMethodNotSupportedException {
        Object domainObj = ContentPropertyRestController.findOne(repositories, repository, id);
        String etag = BeanUtils.getFieldWithAnnotation((Object)domainObj, Version.class) != null ? BeanUtils.getFieldWithAnnotation((Object)domainObj, Version.class).toString() : null;
        Object lastModifiedDate = BeanUtils.getFieldWithAnnotation((Object)domainObj, LastModifiedDate.class) != null ? BeanUtils.getFieldWithAnnotation((Object)domainObj, LastModifiedDate.class) : null;
        HeaderUtils.evaluateHeaderConditions(headers, etag, lastModifiedDate);
        PersistentProperty<?> property = this.getContentPropertyDefinition(repositories.getPersistentEntity(domainObj.getClass()), contentProperty);
        Object contentPropertyValue = this.getContentProperty(domainObj, property, contentId);
        if (BeanUtils.hasFieldWithAnnotation((Object)contentPropertyValue, MimeType.class)) {
            BeanUtils.setFieldWithAnnotation((Object)contentPropertyValue, MimeType.class, (Object)mimeType);
        }
        if (originalFileName != null && StringUtils.hasText((String)originalFileName) && BeanUtils.hasFieldWithAnnotation((Object)contentPropertyValue, OriginalFileName.class)) {
            BeanUtils.setFieldWithAnnotation((Object)contentPropertyValue, OriginalFileName.class, (Object)originalFileName);
        }
        Class<?> contentEntityClass = ContentPropertyUtils.getContentPropertyType(property);
        ContentStoreInfo info = ContentStoreUtils.findContentStore(this.storeService, contentEntityClass);
        info.getImpementation().setContent(contentPropertyValue, stream);
        ContentPropertyRestController.save(repositories, domainObj);
    }
}

