/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.time.Instant;
import java.util.Date;
import java.util.stream.Stream;
import org.springframework.content.commons.annotations.ContentLength;
import org.springframework.content.commons.annotations.OriginalFileName;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.io.Resource;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.convert.Jsr310Converters;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.resource.HttpResource;

public class AssociatedResource
implements HttpResource {
    private final ConfigurableConversionService conversionService = new DefaultConversionService();
    private Object entity;
    private Resource original;

    public AssociatedResource(Object entity, Resource original) {
        Jsr310Converters.getConvertersToRegister().forEach(arg_0 -> ((ConfigurableConversionService)this.conversionService).addConverter(arg_0));
        this.entity = entity;
        this.original = original;
    }

    public long contentLength() throws IOException {
        Long contentLength = (Long)BeanUtils.getFieldWithAnnotation((Object)this.entity, ContentLength.class);
        if (contentLength == null) {
            contentLength = this.original.contentLength();
        }
        return contentLength;
    }

    public long lastModified() throws IOException {
        Object lastModified = BeanUtils.getFieldWithAnnotation((Object)this.entity, LastModifiedDate.class);
        if (lastModified == null) {
            return this.original.lastModified();
        }
        return Stream.of(lastModified).map(it -> (Date)this.conversionService.convert(it, Date.class)).map(it -> (Instant)this.conversionService.convert(it, Instant.class)).map(it -> it.toEpochMilli()).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Invalid data type for @LastModifiedDate for Entity %s", this.entity)));
    }

    public boolean exists() {
        return this.original.exists();
    }

    public boolean isReadable() {
        return this.original.isReadable();
    }

    public boolean isOpen() {
        return this.original.isOpen();
    }

    public boolean isFile() {
        return this.original.isFile();
    }

    public URL getURL() throws IOException {
        return this.original.getURL();
    }

    public URI getURI() throws IOException {
        return this.original.getURI();
    }

    public File getFile() throws IOException {
        return this.original.getFile();
    }

    public ReadableByteChannel readableChannel() throws IOException {
        return this.original.readableChannel();
    }

    public Resource createRelative(String relativePath) throws IOException {
        return this.original.createRelative(relativePath);
    }

    @Nullable
    public String getFilename() {
        return this.original.getFilename();
    }

    public String getDescription() {
        return this.original.getDescription();
    }

    public InputStream getInputStream() throws IOException {
        return this.original.getInputStream();
    }

    public HttpHeaders getResponseHeaders() {
        HttpHeaders headers = new HttpHeaders();
        Object originalFileName = BeanUtils.getFieldWithAnnotation((Object)this.entity, OriginalFileName.class);
        if (originalFileName != null) {
            headers.setContentDispositionFormData("attachment", (String)originalFileName);
        }
        return headers;
    }
}

