/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.links;

import internal.org.springframework.content.rest.utils.ContentStoreUtils;
import internal.org.springframework.content.rest.utils.DomainObjectUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.storeservice.ContentStoreInfo;
import org.springframework.content.commons.storeservice.ContentStoreService;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.rest.config.RestConfiguration;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.mapping.RepositoryResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.support.RepositoryLinkBuilder;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.ResourceProcessor;
import org.springframework.hateoas.mvc.BasicLinkBuilder;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ContentLinksResourceProcessor
implements ResourceProcessor<PersistentEntityResource> {
    private static final Log log = LogFactory.getLog(ContentLinksResourceProcessor.class);
    private ContentStoreService stores;
    private RestConfiguration config;
    private RepositoryResourceMappings mappings;

    public ContentLinksResourceProcessor(Repositories repos, ContentStoreService stores, RestConfiguration config, RepositoryResourceMappings mappings) {
        this.stores = stores;
        this.config = config;
        this.mappings = mappings;
    }

    public PersistentEntityResource process(PersistentEntityResource resource) {
        Object object = resource.getContent();
        if (object == null) {
            return resource;
        }
        Object entityId = DomainObjectUtils.getId(object);
        ContentStoreInfo store = ContentStoreUtils.findContentStore(this.stores, object.getClass());
        Field[] fields = BeanUtils.findFieldsWithAnnotation(object.getClass(), ContentId.class, (BeanWrapper)new BeanWrapperImpl(object));
        if (fields.length == 1) {
            if (store != null) {
                this.originalLink(this.config.getBaseUri(), store, entityId).ifPresent(l -> resource.add(l));
                resource.add(this.shortcutLink(this.config.getBaseUri(), store, entityId, StringUtils.uncapitalize((String)ContentStoreUtils.getSimpleName(store))));
            }
        } else if (fields.length > 1) {
            for (Field field : fields) {
                resource.add(this.fullyQualifiedLink(this.config.getBaseUri(), store, entityId, field.getName()));
            }
        }
        ArrayList<Field> processed = new ArrayList<Field>();
        ResourceMetadata md = this.mappings.getMetadataFor(object.getClass());
        for (Field field : object.getClass().getFields()) {
            processed.add(field);
            this.handleField(field, resource, md, this.config.getBaseUri(), entityId);
        }
        BeanWrapperImpl wrapper = new BeanWrapperImpl(object);
        for (PropertyDescriptor descriptor : wrapper.getPropertyDescriptors()) {
            Field field = null;
            try {
                field = object.getClass().getDeclaredField(descriptor.getName());
                if (processed.contains(field)) continue;
                this.handleField(field, resource, md, this.config.getBaseUri(), entityId);
            }
            catch (NoSuchFieldException nsfe) {
                log.trace((Object)String.format("No field for property %s, ignoring", descriptor.getName()));
            }
            catch (SecurityException se) {
                log.warn((Object)String.format("Unexpected security error while handling content links for property %s", descriptor.getName()));
            }
        }
        return resource;
    }

    private void handleField(Field field, PersistentEntityResource resource, ResourceMetadata metadata, URI baseUri, Object entityId) {
        Class fieldType = field.getType();
        if (fieldType.isArray()) {
            ContentStoreInfo store = ContentStoreUtils.findContentStore(this.stores, fieldType = fieldType.getComponentType());
            if (store != null) {
                resource.add(this.propertyLink(metadata, baseUri, entityId, field.getName(), null));
            }
        } else if (Collection.class.isAssignableFrom(fieldType)) {
            Type type = field.getGenericType();
            if (type instanceof ParameterizedType) {
                Type[] arr;
                ParameterizedType pType = (ParameterizedType)type;
                for (Type tp : arr = pType.getActualTypeArguments()) {
                    fieldType = (Class)tp;
                }
                ContentStoreInfo store = ContentStoreUtils.findContentStore(this.stores, fieldType);
                if (store != null) {
                    Object object = resource.getContent();
                    BeanWrapperImpl wrapper = new BeanWrapperImpl(object);
                    Object value = null;
                    try {
                        value = wrapper.getPropertyValue(field.getName());
                    }
                    catch (InvalidPropertyException ipe) {
                        try {
                            value = ReflectionUtils.getField((Field)field, (Object)object);
                        }
                        catch (IllegalStateException ise) {
                            log.trace((Object)String.format("Didn't get value for property %s", field.getName()));
                        }
                    }
                    if (value != null) {
                        for (Object o : (Collection)value) {
                            String cid;
                            if (!BeanUtils.hasFieldWithAnnotation(o, ContentId.class) || (cid = BeanUtils.getFieldWithAnnotation(o, ContentId.class).toString()) == null) continue;
                            resource.add(this.propertyLink(metadata, baseUri, entityId, field.getName(), cid));
                        }
                    }
                }
            }
        } else {
            ContentStoreInfo store = ContentStoreUtils.findContentStore(this.stores, fieldType);
            if (store != null) {
                String cid;
                Object object = resource.getContent();
                BeanWrapperImpl wrapper = new BeanWrapperImpl(object);
                Object value = null;
                try {
                    value = wrapper.getPropertyValue(field.getName());
                }
                catch (InvalidPropertyException ipe) {
                    try {
                        value = ReflectionUtils.getField((Field)field, (Object)object);
                    }
                    catch (IllegalStateException ise) {
                        log.trace((Object)String.format("Didn't get value for property %s", field.getName()));
                    }
                }
                if (value != null && (cid = BeanUtils.getFieldWithAnnotation((Object)value, ContentId.class).toString()) != null) {
                    resource.add(this.propertyLink(metadata, baseUri, entityId, field.getName(), cid));
                }
            }
        }
    }

    private Optional<Link> originalLink(URI baseUri, ContentStoreInfo store, Object id) {
        if (id == null) {
            return Optional.empty();
        }
        return Optional.of(this.shortcutLink(baseUri, store, id, ContentStoreUtils.storePath(store)));
    }

    private Link shortcutLink(URI baseUri, ContentStoreInfo store, Object id, String linkRel) {
        BasicLinkBuilder builder = BasicLinkBuilder.linkToCurrentMapping();
        if (baseUri != null) {
            builder = builder.slash((Object)baseUri);
        }
        return builder.slash((Object)ContentStoreUtils.storePath(store)).slash(id).withRel(linkRel);
    }

    private Link fullyQualifiedLink(URI baseUri, ContentStoreInfo store, Object id, String fieldName) {
        BasicLinkBuilder builder = BasicLinkBuilder.linkToCurrentMapping();
        if (baseUri != null) {
            builder = builder.slash((Object)baseUri);
        }
        String property = StringUtils.uncapitalize((String)ContentStoreUtils.propertyName(fieldName));
        return builder.slash((Object)ContentStoreUtils.storePath(store)).slash(id).slash((Object)property).withRel(property);
    }

    private Link propertyLink(ResourceMetadata md, URI baseUri, Object id, String property, String contentId) {
        RepositoryLinkBuilder builder = new RepositoryLinkBuilder(md, new BaseUri(baseUri));
        builder = builder.slash(id).slash((Object)property);
        if (contentId != null) {
            builder = builder.slash((Object)contentId);
        }
        return builder.withRel(property);
    }

    protected Object invokeField(Field field, Object object) {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

