/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.utils;

import internal.org.springframework.content.rest.annotations.ContentStoreRestResource;
import internal.org.springframework.content.rest.io.AssociatedResource;
import internal.org.springframework.content.rest.io.RenderedResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.atteo.evo.inflector.English;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.annotations.MimeType;
import org.springframework.content.commons.renditions.Renderable;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.storeservice.ContentStoreInfo;
import org.springframework.content.commons.storeservice.ContentStoreService;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.rest.StoreRestResource;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class ContentStoreUtils {
    private ContentStoreUtils() {
    }

    public static ResourcePlan resolveResource(ContentStore<Object, Serializable> store, Object entity, Object property, List<MediaType> mimeTypes) {
        Object entityMimeType = BeanUtils.getFieldWithAnnotation((Object)(property != null ? property : entity), MimeType.class);
        if (entityMimeType == null) {
            return new ResourcePlan(new NonExistentResource(), null);
        }
        MediaType targetMimeType = MediaType.valueOf((String)entityMimeType.toString());
        MediaType.sortBySpecificityAndQuality(mimeTypes);
        MediaType[] arrMimeTypes = mimeTypes.toArray(new MediaType[0]);
        Serializable contentId = (Serializable)BeanUtils.getFieldWithAnnotation((Object)(property != null ? property : entity), ContentId.class);
        Object r = null;
        MediaType mimeType = null;
        for (int i = 0; i < arrMimeTypes.length; ++i) {
            InputStream content;
            mimeType = arrMimeTypes[i];
            if (mimeType.includes((org.springframework.util.MimeType)targetMimeType)) {
                r = ((Store)store).getResource(contentId);
                r = new AssociatedResource(entity, (Resource)r);
                mimeType = targetMimeType;
                break;
            }
            if (!(store instanceof Renderable) || (content = ((Renderable)store).getRendition(property != null ? property : entity, mimeType.toString())) == null) continue;
            Resource original = ((Store)store).getResource(contentId);
            r = new AssociatedResource(entity, original);
            r = new RenderedResource(content, (Resource)r);
            break;
        }
        if (r != null) {
            // empty if block
        }
        return new ResourcePlan((Resource)r, (org.springframework.util.MimeType)mimeType);
    }

    public static ContentStoreInfo findContentStore(ContentStoreService stores, Class<?> contentEntityClass) {
        for (ContentStoreInfo info : stores.getStores(ContentStore.class)) {
            if (!contentEntityClass.equals(info.getDomainObjectClass())) continue;
            return info;
        }
        return null;
    }

    public static ContentStoreInfo findContentStore(ContentStoreService stores, String store) {
        for (ContentStoreInfo info : stores.getStores(ContentStore.class)) {
            if (!store.equals(ContentStoreUtils.storePath(info))) continue;
            return info;
        }
        return null;
    }

    public static ContentStoreInfo findStore(ContentStoreService stores, String store) {
        for (ContentStoreInfo info : stores.getStores(Store.class)) {
            if (!store.equals(ContentStoreUtils.storePath(info))) continue;
            return info;
        }
        return null;
    }

    public static String storePath(ContentStoreInfo info) {
        StoreRestResource newAnnotation;
        Class clazz = info.getInterface();
        String path = null;
        ContentStoreRestResource oldAnnotation = (ContentStoreRestResource)AnnotationUtils.findAnnotation((Class)clazz, ContentStoreRestResource.class);
        path = oldAnnotation != null ? (oldAnnotation == null ? null : oldAnnotation.path().trim()) : ((newAnnotation = (StoreRestResource)AnnotationUtils.findAnnotation((Class)clazz, StoreRestResource.class)) == null ? null : newAnnotation.path().trim());
        path = StringUtils.hasText((String)path) ? path : English.plural((String)StringUtils.uncapitalize((String)ContentStoreUtils.getSimpleName(info)));
        return path;
    }

    public static String getSimpleName(ContentStoreInfo info) {
        Class clazz = info.getDomainObjectClass();
        return clazz != null ? clazz.getSimpleName() : ContentStoreUtils.stripStoreName(info.getInterface());
    }

    public static String stripStoreName(Class<?> iface) {
        return iface.getSimpleName().replaceAll("Store", "");
    }

    public static String propertyName(String fieldName) {
        String name = ContentStoreUtils.stripId(fieldName);
        name = ContentStoreUtils.stripLength(name);
        return ContentStoreUtils.stripMimeType(name);
    }

    private static String stripId(String fieldName) {
        String name = fieldName.replaceAll("_Id", "");
        name = name.replaceAll("Id", "");
        name = name.replaceAll("_id", "");
        return name.replaceAll("id", "");
    }

    private static String stripLength(String fieldName) {
        String name = fieldName.replaceAll("_Length", "");
        name = name.replaceAll("Length", "");
        name = name.replaceAll("_length", "");
        name = name.replaceAll("length", "");
        name = fieldName.replaceAll("_len", "");
        name = name.replaceAll("Len", "");
        name = name.replaceAll("_len", "");
        return name.replaceAll("len", "");
    }

    private static String stripMimeType(String fieldName) {
        String name = fieldName.replaceAll("_MimeType", "");
        name = name.replaceAll("_Mime_Type", "");
        name = name.replaceAll("MimeType", "");
        name = name.replaceAll("_mimetype", "");
        name = name.replaceAll("_mime_type", "");
        name = name.replaceAll("mimetype", "");
        name = fieldName.replaceAll("_ContentType", "");
        name = name.replaceAll("_Content_Type", "");
        name = name.replaceAll("ContentType", "");
        name = name.replaceAll("_contenttype", "");
        name = name.replaceAll("_content_type", "");
        return name.replaceAll("contenttype", "");
    }

    public static String storeLookupPath(String lookupPath, URI baseUri) {
        Assert.notNull((Object)lookupPath, (String)"Lookup path must not be null!");
        lookupPath = lookupPath.replaceAll("//", "/");
        lookupPath = StringUtils.trimTrailingCharacter((String)lookupPath, (char)'/');
        if (baseUri.isAbsolute()) {
            throw new UnsupportedOperationException("Absolute BaseUri is not supported");
        }
        String uri = baseUri.toString();
        if (!StringUtils.hasText((String)uri)) {
            return lookupPath;
        }
        uri = uri.startsWith("/") ? uri : "/".concat(uri);
        return lookupPath.startsWith(uri) ? lookupPath.substring(uri.length(), lookupPath.length()) : null;
    }

    public static class NonExistentResource
    implements Resource {
        public boolean exists() {
            return false;
        }

        public URL getURL() throws IOException {
            throw new UnsupportedOperationException();
        }

        public URI getURI() throws IOException {
            throw new UnsupportedOperationException();
        }

        public File getFile() throws IOException {
            throw new UnsupportedOperationException();
        }

        public long contentLength() throws IOException {
            throw new UnsupportedOperationException();
        }

        public long lastModified() throws IOException {
            throw new UnsupportedOperationException();
        }

        public Resource createRelative(String s) throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getFilename() {
            throw new UnsupportedOperationException();
        }

        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        public InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static class ResourcePlan {
        private Resource resource;
        private org.springframework.util.MimeType mimeType;

        public ResourcePlan(Resource r, org.springframework.util.MimeType mimeType) {
            this.resource = r;
            this.mimeType = mimeType;
        }

        public Resource getResource() {
            return this.resource;
        }

        public org.springframework.util.MimeType getMimeType() {
            return this.mimeType;
        }
    }
}

