/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.utils;

import java.util.Optional;
import org.atteo.evo.inflector.English;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.annotation.RepositoryRestResource;
import org.springframework.util.StringUtils;

public final class RepositoryUtils {
    private RepositoryUtils() {
    }

    public static String repositoryPath(RepositoryInformation info) {
        Class clazz = info.getRepositoryInterface();
        RepositoryRestResource annotation = (RepositoryRestResource)AnnotationUtils.findAnnotation((Class)clazz, RepositoryRestResource.class);
        String path = annotation == null ? null : annotation.path().trim();
        path = StringUtils.hasText((String)path) ? path : English.plural((String)StringUtils.uncapitalize((String)info.getDomainType().getSimpleName()));
        return path;
    }

    public static RepositoryInformation findRepositoryInformation(Repositories repositories, String repository) {
        RepositoryInformation ri = null;
        for (Class clazz : repositories) {
            Optional candidate = repositories.getRepositoryInformationFor(clazz);
            if (!candidate.isPresent() || !repository.equals(RepositoryUtils.repositoryPath((RepositoryInformation)candidate.get()))) continue;
            ri = (RepositoryInformation)candidate.get();
            break;
        }
        return ri;
    }

    public static RepositoryInformation findRepositoryInformation(Repositories repositories, Class<?> domainObjectClass) {
        RepositoryInformation ri = null;
        for (Class clazz : repositories) {
            if (!clazz.equals(domainObjectClass)) continue;
            return (RepositoryInformation)repositories.getRepositoryInformationFor(clazz).get();
        }
        return ri;
    }
}

