/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.rest.config;

import internal.org.springframework.content.rest.mappings.ContentHandlerMapping;
import internal.org.springframework.content.rest.mappings.StoreByteRangeHttpRequestHandler;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.storeservice.ContentStoreService;
import org.springframework.content.rest.config.ContentRestConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@ComponentScan(value={"internal.org.springframework.content.rest.controllers, org.springframework.data.rest.extensions"})
public class RestConfiguration
implements InitializingBean {
    private static final URI NO_URI = URI.create("");
    @Autowired
    ContentStoreService stores;
    @Autowired(required=false)
    private List<ContentRestConfigurer> configurers = new ArrayList<ContentRestConfigurer>();
    private URI baseUri = NO_URI;

    public URI getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(URI baseUri) {
        this.baseUri = baseUri;
    }

    @Bean
    RequestMappingHandlerMapping contentHandlerMapping() {
        return new ContentHandlerMapping(this.stores, this);
    }

    @Bean
    StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler() {
        return new StoreByteRangeHttpRequestHandler();
    }

    public void afterPropertiesSet() throws Exception {
        for (ContentRestConfigurer configurer : this.configurers) {
            configurer.configure(this);
        }
    }
}

