/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.extensions.versioning;

import internal.org.springframework.content.rest.utils.RepositoryUtils;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.utils.ReflectionService;
import org.springframework.content.commons.utils.ReflectionServiceImpl;
import org.springframework.data.domain.Page;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.core.EmbeddedWrappers;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ReflectionUtils;
import org.springframework.versions.LockingAndVersioningRepository;
import org.springframework.versions.VersionInfo;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RepositoryRestController
public class LockingAndVersioningRestController {
    private static final EmbeddedWrappers WRAPPERS = new EmbeddedWrappers(false);
    private static final String ENTITY_LOCK_MAPPING = "/{repository}/{id}/lock";
    private static final String ENTITY_VERSION_MAPPING = "/{repository}/{id}/version";
    private static final String ENTITY_FINDALLLATESTVERSION_MAPPING = "/{repository}/findAllVersionsLatest";
    private static final String FINDALLVERSIONS_METHOD_MAPPING = "/{repository}/{id}/findAllVersions";
    private static Method LOCK_METHOD = null;
    private static Method UNLOCK_METHOD = null;
    private static Method VERSION_METHOD = null;
    private static Method FINDALLLATESTVERSION_METHOD = null;
    private static Method FINDALLVERSIONS_METHOD = null;
    private Repositories repositories;
    private PagedResourcesAssembler<Object> pagedResourcesAssembler;
    private ReflectionService reflectionService;

    @Autowired
    public LockingAndVersioningRestController(Repositories repositories, PagedResourcesAssembler<Object> assembler) {
        this.repositories = repositories;
        this.pagedResourcesAssembler = assembler;
        this.reflectionService = new ReflectionServiceImpl();
    }

    public void setReflectionService(ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/{id}/lock"}, method={RequestMethod.PUT})
    public ResponseEntity<Resource<?>> lock(RootResourceInformation repoInfo, @PathVariable String repository, @PathVariable String id, Principal principal) throws ResourceNotFoundException, HttpRequestMethodNotSupportedException {
        Object domainObj = repoInfo.getInvoker().invokeFindById((Object)id).get();
        if ((domainObj = ReflectionUtils.invokeMethod((Method)LOCK_METHOD, this.repositories.getRepositoryFor(domainObj.getClass()).get(), (Object[])new Object[]{domainObj})) != null) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).build();
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/{id}/lock"}, method={RequestMethod.DELETE})
    public ResponseEntity<Resource<?>> unlock(RootResourceInformation repoInfo, @PathVariable String repository, @PathVariable String id, Principal principal) throws ResourceNotFoundException, HttpRequestMethodNotSupportedException {
        Object domainObj = repoInfo.getInvoker().invokeFindById((Object)id).get();
        if ((domainObj = ReflectionUtils.invokeMethod((Method)UNLOCK_METHOD, this.repositories.getRepositoryFor(domainObj.getClass()).get(), (Object[])new Object[]{domainObj})) != null) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).build();
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/{id}/version"}, method={RequestMethod.PUT})
    public ResponseEntity<Resource<?>> version(RootResourceInformation repoInfo, @PathVariable String repository, @PathVariable String id, @RequestBody VersionInfo info, Principal principal, PersistentEntityResourceAssembler assembler) throws ResourceNotFoundException, HttpRequestMethodNotSupportedException {
        Object domainObj = repoInfo.getInvoker().invokeFindById((Object)id).get();
        if ((domainObj = ReflectionUtils.invokeMethod((Method)VERSION_METHOD, this.repositories.getRepositoryFor(domainObj.getClass()).get(), (Object[])new Object[]{domainObj, info})) != null) {
            return new ResponseEntity((Object)assembler.toResource(domainObj), HttpStatus.OK);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).build();
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/findAllVersionsLatest"}, method={RequestMethod.GET})
    public ResponseEntity<?> findAllLatestVersion(RootResourceInformation repoInfo, PersistentEntityResourceAssembler assembler, @PathVariable String repository) throws ResourceNotFoundException, HttpRequestMethodNotSupportedException {
        RepositoryInformation repositoryInfo = RepositoryUtils.findRepositoryInformation(this.repositories, repository);
        Class domainType = repositoryInfo.getDomainType();
        List result = (List)ReflectionUtils.invokeMethod((Method)FINDALLLATESTVERSION_METHOD, this.repositories.getRepositoryFor(domainType).get());
        return ResponseEntity.ok(LockingAndVersioningRestController.toResources(result, assembler, this.pagedResourcesAssembler, domainType, null));
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/{id}/findAllVersions"}, method={RequestMethod.GET})
    public ResponseEntity<?> findAllVersions(RootResourceInformation repoInfo, PersistentEntityResourceAssembler assembler, @PathVariable String repository, @PathVariable String id) throws ResourceNotFoundException, HttpRequestMethodNotSupportedException {
        Object domainObj = repoInfo.getInvoker().invokeFindById((Object)id).get();
        List result = (List)ReflectionUtils.invokeMethod((Method)FINDALLVERSIONS_METHOD, this.repositories.getRepositoryFor(domainObj.getClass()).get(), (Object[])new Object[]{domainObj});
        return ResponseEntity.ok(LockingAndVersioningRestController.toResources(result, assembler, this.pagedResourcesAssembler, domainObj.getClass(), null));
    }

    public static Resources<?> toResources(Iterable<?> source, PersistentEntityResourceAssembler assembler, PagedResourcesAssembler resourcesAssembler, Class<?> domainType, Link baseLink) {
        if (source instanceof Page) {
            Page page = (Page)source;
            return LockingAndVersioningRestController.entitiesToResources((Page<Object>)page, assembler, resourcesAssembler, domainType, baseLink);
        }
        if (source instanceof Iterable) {
            return LockingAndVersioningRestController.entitiesToResources(source, assembler, domainType);
        }
        return new Resources(ControllerUtils.EMPTY_RESOURCE_LIST, new Link[0]);
    }

    protected static Resources<?> entitiesToResources(Page<Object> page, PersistentEntityResourceAssembler assembler, PagedResourcesAssembler resourcesAssembler, Class<?> domainType, Link baseLink) {
        if (page.getContent().isEmpty()) {
            return resourcesAssembler.toEmptyResource(page, domainType, baseLink);
        }
        return baseLink == null ? resourcesAssembler.toResource(page, (ResourceAssembler)assembler) : resourcesAssembler.toResource(page, (ResourceAssembler)assembler, baseLink);
    }

    protected static Resources<?> entitiesToResources(Iterable<Object> entities, PersistentEntityResourceAssembler assembler, Class<?> domainType) {
        if (!entities.iterator().hasNext()) {
            List<Object> content = Arrays.asList(WRAPPERS.emptyCollectionOf(domainType));
            return new Resources(content, new Link[]{LockingAndVersioningRestController.getDefaultSelfLink()});
        }
        ArrayList<PersistentEntityResource> resources = new ArrayList<PersistentEntityResource>();
        for (Object obj : entities) {
            resources.add(obj == null ? null : assembler.toResource(obj));
        }
        return new Resources(resources, new Link[]{LockingAndVersioningRestController.getDefaultSelfLink()});
    }

    protected static Link getDefaultSelfLink() {
        return new Link(ServletUriComponentsBuilder.fromCurrentRequest().build().toUriString());
    }

    static {
        LOCK_METHOD = ReflectionUtils.findMethod(LockingAndVersioningRepository.class, (String)"lock", (Class[])new Class[]{Object.class});
        UNLOCK_METHOD = ReflectionUtils.findMethod(LockingAndVersioningRepository.class, (String)"unlock", (Class[])new Class[]{Object.class});
        VERSION_METHOD = ReflectionUtils.findMethod(LockingAndVersioningRepository.class, (String)"version", (Class[])new Class[]{Object.class, VersionInfo.class});
        FINDALLLATESTVERSION_METHOD = ReflectionUtils.findMethod(LockingAndVersioningRepository.class, (String)"findAllVersionsLatest");
        FINDALLVERSIONS_METHOD = ReflectionUtils.findMethod(LockingAndVersioningRepository.class, (String)"findAllVersions", (Class[])new Class[]{Object.class});
    }
}

