/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.s3.boot.autoconfigure;

import internal.org.springframework.content.commons.utils.ContentRepositoryUtils;
import internal.org.springframework.content.s3.config.S3ContentRepositoriesRegistrar;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.content.s3.config.EnableS3ContentRepositories;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;

public class S3ContentAutoConfigureRegistrar
extends S3ContentRepositoriesRegistrar {
    protected void registerContentStoreBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        StandardAnnotationMetadata metadata = new StandardAnnotationMetadata(EnableS3ContentAutoConfiguration.class);
        AnnotationAttributes attributes = new AnnotationAttributes(metadata.getAnnotationAttributes(this.getAnnotation().getName()));
        String[] basePackages = this.getBasePackages();
        Set definitions = ContentRepositoryUtils.getContentRepositoryCandidates((ResourceLoader)this.getResourceLoader(), (String[])basePackages);
        for (BeanDefinition definition : definitions) {
            String factoryBeanName = ContentRepositoryUtils.getRepositoryFactoryBeanName((AnnotationAttributes)attributes);
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)factoryBeanName);
            builder.getRawBeanDefinition().setSource((Object)importingClassMetadata);
            builder.addPropertyValue("contentStoreInterface", (Object)definition.getBeanClassName());
            registry.registerBeanDefinition(ContentRepositoryUtils.getRepositoryBeanName((BeanDefinition)definition), (BeanDefinition)builder.getBeanDefinition());
        }
    }

    protected String[] getBasePackages() {
        return AutoConfigurationPackages.get((BeanFactory)this.getBeanFactory()).toArray(new String[0]);
    }

    @EnableS3ContentRepositories
    private static class EnableS3ContentAutoConfiguration {
        private EnableS3ContentAutoConfiguration() {
        }
    }
}

