/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.s3.config;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.s3.config.S3ObjectIdResolvers;
import org.springframework.content.s3.config.S3StoreConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;

@Configuration
public class S3StoreConfiguration {
    @Autowired(required=false)
    private List<S3StoreConfigurer> configurers;

    @Bean
    public S3ObjectIdResolvers contentIdResolvers() {
        S3ObjectIdResolvers resolvers = new S3ObjectIdResolvers();
        if (this.configurers != null) {
            for (S3StoreConfigurer configurer : this.configurers) {
                configurer.configureS3ObjectIdResolvers(resolvers);
            }
        }
        return resolvers;
    }

    @Bean
    public ConversionService s3StoreConverter() {
        DefaultConversionService conversion = new DefaultConversionService();
        this.addConverters(conversion);
        return conversion;
    }

    private void addConverters(DefaultConversionService conversion) {
        if (this.configurers == null) {
            return;
        }
        for (S3StoreConfigurer configurer : this.configurers) {
            configurer.configureS3StoreConverters((ConverterRegistry)conversion);
        }
    }
}

