/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.s3.config;

import com.amazonaws.services.s3.AmazonS3;
import internal.org.springframework.content.s3.config.DefaultAssociativeStoreS3ObjectIdResolver;
import internal.org.springframework.content.s3.store.DefaultS3StoreImpl;
import java.io.Serializable;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.aws.core.io.s3.SimpleStorageProtocolResolver;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.repository.factory.AbstractStoreFactoryBean;
import org.springframework.content.s3.S3ObjectIdResolver;
import org.springframework.content.s3.config.S3ObjectIdResolvers;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.ResourceLoader;
import org.springframework.versions.LockingAndVersioningProxyFactory;

public class S3StoreFactoryBean
extends AbstractStoreFactoryBean {
    public static final S3ObjectIdResolver<Serializable> DEFAULT_S3OBJECTID_RESOLVER_STORE = S3ObjectIdResolver.createDefaultS3ObjectIdHelper();
    @Autowired
    private AmazonS3 client;
    @Autowired
    private ConversionService s3StoreConverter;
    @Autowired
    private S3ObjectIdResolvers resolvers;
    @Autowired(required=false)
    private LockingAndVersioningProxyFactory versioning;
    @Value(value="${spring.content.s3.bucket:#{environment.AWS_BUCKET}}")
    private String bucket;

    public S3StoreFactoryBean() {
    }

    @Autowired
    public S3StoreFactoryBean(AmazonS3 client, ConversionService s3StoreConverter, S3ObjectIdResolvers resolvers) {
        this.client = client;
        this.s3StoreConverter = s3StoreConverter;
        this.resolvers = resolvers;
    }

    protected void addProxyAdvice(ProxyFactory result, BeanFactory beanFactory) {
        if (this.versioning != null) {
            this.versioning.apply(result);
        }
    }

    protected Object getContentStoreImpl() {
        DefaultAssociativeStoreS3ObjectIdResolver resolver = null;
        if (AssociativeStore.class.isAssignableFrom(this.getStoreInterface()) || ContentStore.class.isAssignableFrom(this.getStoreInterface())) {
            resolver = this.resolvers.getResolverFor(this.getDomainClass(this.getStoreInterface()));
            if (resolver == null && (resolver = this.resolvers.getResolverFor(this.getContentIdClass(this.getStoreInterface()))) == null) {
                resolver = new DefaultAssociativeStoreS3ObjectIdResolver(this.s3StoreConverter);
            }
        } else if (Store.class.isAssignableFrom(this.getStoreInterface()) && (resolver = this.resolvers.getResolverFor(this.getContentIdClass(this.getStoreInterface()))) == null) {
            resolver = DEFAULT_S3OBJECTID_RESOLVER_STORE;
        }
        SimpleStorageProtocolResolver s3Protocol = new SimpleStorageProtocolResolver(this.client);
        s3Protocol.afterPropertiesSet();
        DefaultResourceLoader loader = new DefaultResourceLoader();
        loader.addProtocolResolver((ProtocolResolver)s3Protocol);
        return new DefaultS3StoreImpl((ResourceLoader)loader, this.s3StoreConverter, this.client, resolver, this.bucket);
    }
}

