/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.s3;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.util.Assert;

public interface S3ObjectIdResolver<I> {
    default public String getBucket(I idOrEntity, String defaultBucketName) {
        return defaultBucketName;
    }

    default public String getKey(I idOrEntity) {
        return Objects.requireNonNull(idOrEntity, "ContentId must not be null").toString();
    }

    default public void validate(I idOrEntity) {
        Assert.notNull(idOrEntity, (String)"ContentId must not be null");
    }

    public static <I> S3ObjectIdResolver<I> createDefaultS3ObjectIdHelper() {
        return new S3ObjectIdResolver<I>(){};
    }

    public static <I> S3ObjectIdResolver<I> createS3ObjectIdResolver(final Function<I, String> getBucketFunction, final Function<I, String> getObjectIdFunction, final Consumer<I> validateConsumer) {
        return new S3ObjectIdResolver<I>(){

            @Override
            public String getBucket(I idOrEntity, String defaultBucketName) {
                String bucketName = (String)getBucketFunction.apply(idOrEntity);
                return null != bucketName ? bucketName : defaultBucketName;
            }

            @Override
            public String getKey(I idOrEntity) {
                return (String)getObjectIdFunction.apply(idOrEntity);
            }

            @Override
            public void validate(I idOrEntity) {
                if (validateConsumer != null) {
                    validateConsumer.accept(idOrEntity);
                }
            }
        };
    }
}

