/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.s3.config;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.config.ContentPropertyInfo;
import org.springframework.content.commons.repository.StoreAccessException;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.commons.utils.PlacementService;
import org.springframework.content.commons.utils.PlacementServiceImpl;
import org.springframework.content.s3.Bucket;
import org.springframework.content.s3.S3ObjectId;
import org.springframework.content.s3.config.S3StoreConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;

@Configuration
public class S3StoreConfiguration
implements InitializingBean {
    @Autowired(required=false)
    private List<S3StoreConfigurer> configurers;
    @Value(value="${spring.content.s3.bucket:#{environment.AWS_BUCKET}}")
    private String bucket;
    private PlacementService conversion = new PlacementServiceImpl();

    @Bean
    public PlacementService s3StorePlacementService() {
        return this.conversion;
    }

    public static void addDefaultS3ObjectIdConverters(PlacementService conversion, final String bucket) {
        conversion.addConverter((Converter)new Converter<Serializable, S3ObjectId>(){
            private String defaultBucket;
            {
                this.defaultBucket = bucket;
            }

            public S3ObjectId convert(Serializable id) {
                return new S3ObjectId(this.defaultBucket, Objects.requireNonNull(id, "ContentId must not be null").toString());
            }
        });
        conversion.addConverter((Converter)new Converter<Object, S3ObjectId>(){
            private String defaultBucket;
            {
                this.defaultBucket = bucket;
            }

            public S3ObjectId convert(Object idOrEntity) {
                Object contentId;
                String strBucket = null;
                Object bucket2 = BeanUtils.getFieldWithAnnotation((Object)idOrEntity, Bucket.class);
                if (bucket2 == null) {
                    bucket2 = this.defaultBucket;
                }
                if (bucket2 == null) {
                    throw new StoreAccessException("Bucket not set");
                }
                strBucket = bucket2.toString();
                String key = null;
                key = BeanUtils.hasFieldWithAnnotation((Object)idOrEntity, ContentId.class) ? ((contentId = BeanUtils.getFieldWithAnnotation((Object)idOrEntity, ContentId.class)) != null ? contentId.toString() : null) : idOrEntity.toString();
                return key != null ? new S3ObjectId(strBucket, key) : null;
            }
        });
        conversion.addConverter((Converter)new Converter<ContentPropertyInfo<Object, Serializable>, S3ObjectId>(){
            private String defaultBucket;
            {
                this.defaultBucket = bucket;
            }

            public S3ObjectId convert(ContentPropertyInfo<Object, Serializable> info) {
                String strBucket = null;
                Object bucket2 = BeanUtils.getFieldWithAnnotation((Object)info.entity(), Bucket.class);
                if (bucket2 == null) {
                    bucket2 = this.defaultBucket;
                }
                if (bucket2 == null) {
                    throw new StoreAccessException("Bucket not set");
                }
                strBucket = bucket2.toString();
                Serializable key = info.contentId();
                return key != null ? new S3ObjectId(strBucket, key.toString()) : null;
            }
        });
    }

    private void addConverters(ConverterRegistry registry) {
        if (this.configurers == null) {
            return;
        }
        for (S3StoreConfigurer configurer : this.configurers) {
            configurer.configureS3StoreConverters(registry);
        }
    }

    public void afterPropertiesSet() throws Exception {
        S3StoreConfiguration.addDefaultS3ObjectIdConverters(this.conversion, this.bucket);
        this.addConverters((ConverterRegistry)this.conversion);
    }
}

