/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.s3.config;

import internal.org.springframework.content.s3.io.SimpleStorageProtocolResolver;
import internal.org.springframework.content.s3.store.DefaultReactiveS3StoreImpl;
import internal.org.springframework.content.s3.store.DefaultS3StoreImpl;
import org.apache.commons.lang.ClassUtils;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.content.commons.mappingcontext.MappingContext;
import org.springframework.content.commons.repository.ReactiveContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.store.factory.AbstractStoreFactoryBean;
import org.springframework.content.commons.utils.PlacementService;
import org.springframework.content.s3.config.MultiTenantS3ClientProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.ResourceLoader;
import org.springframework.versions.LockingAndVersioningProxyFactory;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;

public class S3StoreFactoryBean
extends AbstractStoreFactoryBean {
    @Autowired
    private ApplicationContext context;
    @Autowired
    private S3Client client;
    @Autowired(required=false)
    private S3AsyncClient asyncClient;
    @Autowired
    private PlacementService s3StorePlacementService;
    @Autowired(required=false)
    private MultiTenantS3ClientProvider s3Provider = null;
    @Autowired(required=false)
    private LockingAndVersioningProxyFactory versioning;
    @Autowired(required=false)
    private MappingContext mappingContext;
    @Value(value="${spring.content.s3.bucket:#{environment.AWS_BUCKET}}")
    private String bucket;

    @Autowired
    public S3StoreFactoryBean(Class<? extends Store> storeInterface, ApplicationContext context, S3Client client, PlacementService s3StorePlacementService) {
        super(storeInterface);
        this.context = context;
        this.client = client;
        this.s3StorePlacementService = s3StorePlacementService;
    }

    protected void addProxyAdvice(ProxyFactory result, BeanFactory beanFactory) {
        if (this.versioning != null) {
            this.versioning.apply(result);
        }
    }

    protected Object getContentStoreImpl() {
        SimpleStorageProtocolResolver s3Protocol = new SimpleStorageProtocolResolver(this.client);
        s3Protocol.afterPropertiesSet();
        DefaultResourceLoader loader = new DefaultResourceLoader();
        loader.addProtocolResolver((ProtocolResolver)s3Protocol);
        if (!ClassUtils.getAllInterfaces((Class)this.getStoreInterface()).contains(ReactiveContentStore.class)) {
            if (this.client == null) {
                throw new NoSuchBeanDefinitionException(S3Client.class.getCanonicalName());
            }
            return new DefaultS3StoreImpl(this.context, (ResourceLoader)loader, this.mappingContext, this.s3StorePlacementService, this.client, this.s3Provider);
        }
        if (this.asyncClient == null) {
            throw new NoSuchBeanDefinitionException(S3AsyncClient.class.getCanonicalName());
        }
        return new DefaultReactiveS3StoreImpl(this.context, (ResourceLoader)loader, this.mappingContext, this.s3StorePlacementService, this.asyncClient, this.s3Provider);
    }
}

