/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.s3.io;

import internal.org.springframework.content.s3.io.SimpleStorageResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import org.springframework.content.commons.io.DeletableResource;
import org.springframework.content.commons.io.RangeableResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;

public class S3StoreResource
implements WritableResource,
DeletableResource,
RangeableResource {
    private S3Client client;
    private Resource delegate;
    private String bucket;

    public S3StoreResource(S3Client client, String bucket, Resource delegate) {
        Assert.notNull((Object)client, (String)"client must be specified");
        Assert.hasText((String)bucket, (String)"bucket must be specified");
        Assert.isInstanceOf(WritableResource.class, (Object)delegate);
        this.client = client;
        this.bucket = bucket;
        this.delegate = delegate;
    }

    public S3Client getClient() {
        return this.client;
    }

    public boolean exists() {
        return this.delegate.exists();
    }

    public boolean isReadable() {
        return this.delegate.isReadable();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public URL getURL() throws IOException {
        return this.delegate.getURL();
    }

    public URI getURI() throws IOException {
        return this.delegate.getURI();
    }

    public File getFile() throws IOException {
        return this.delegate.getFile();
    }

    public long contentLength() throws IOException {
        return this.delegate.contentLength();
    }

    public long lastModified() throws IOException {
        return this.delegate.lastModified();
    }

    public Resource createRelative(String relativePath) throws IOException {
        return this.delegate.createRelative(relativePath);
    }

    public String getFilename() {
        return this.delegate.getFilename();
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public InputStream getInputStream() throws IOException {
        return this.delegate.getInputStream();
    }

    public void delete() {
        if (this.delegate.exists()) {
            DeleteObjectRequest deleteObjectRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucket).key(this.delegate.getFilename()).build();
            this.client.deleteObject(deleteObjectRequest);
        }
    }

    public boolean isWritable() {
        return ((WritableResource)this.delegate).isWritable();
    }

    public OutputStream getOutputStream() throws IOException {
        return ((WritableResource)this.delegate).getOutputStream();
    }

    public void setRange(String range) {
        ((RangeableResource)this.delegate).setRange(range);
    }

    public void setContentType(String contentType) {
        if (this.delegate instanceof SimpleStorageResource) {
            ((SimpleStorageResource)this.delegate).setContentType(contentType);
        }
    }

    public String contentType() throws IOException {
        if (this.delegate instanceof SimpleStorageResource) {
            return ((SimpleStorageResource)this.delegate).contentType();
        }
        return null;
    }
}

